/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.models;

import com.microsoft.windowsazure.core.pipeline.Base64StringAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="BlockList")
public class BlockList {
    private List<Entry> entries = new ArrayList<Entry>();

    public BlockList addCommittedEntry(String blockId) {
        CommittedEntry entry = new CommittedEntry();
        entry.setBlockId(blockId);
        this.getEntries().add(entry);
        return this;
    }

    public BlockList addUncommittedEntry(String blockId) {
        UncommittedEntry entry = new UncommittedEntry();
        entry.setBlockId(blockId);
        this.getEntries().add(entry);
        return this;
    }

    public BlockList addLatestEntry(String blockId) {
        LatestEntry entry = new LatestEntry();
        entry.setBlockId(blockId);
        this.getEntries().add(entry);
        return this;
    }

    @XmlElementRefs(value={@XmlElementRef(name="Committed", type=CommittedEntry.class), @XmlElementRef(name="Uncommitted", type=UncommittedEntry.class), @XmlElementRef(name="Latest", type=LatestEntry.class)})
    @XmlMixed
    public List<Entry> getEntries() {
        return this.entries;
    }

    public BlockList setEntries(List<Entry> entries) {
        this.entries = entries;
        return this;
    }

    @XmlRootElement(name="Latest")
    public static class LatestEntry
    extends Entry {
    }

    @XmlRootElement(name="Uncommitted")
    public static class UncommittedEntry
    extends Entry {
    }

    @XmlRootElement(name="Committed")
    public static class CommittedEntry
    extends Entry {
    }

    public static abstract class Entry {
        private String blockId;

        @XmlJavaTypeAdapter(value=Base64StringAdapter.class)
        @XmlValue
        public String getBlockId() {
            return this.blockId;
        }

        public void setBlockId(String blockId) {
            this.blockId = blockId;
        }
    }
}

