/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.models;

import com.microsoft.windowsazure.services.blob.implementation.ContainerACLDateAdapter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class ContainerACL {
    private String etag;
    private Date lastModified;
    private PublicAccessType publicAccess;
    private List<SignedIdentifier> signedIdentifiers = new ArrayList<SignedIdentifier>();

    public String getEtag() {
        return this.etag;
    }

    public ContainerACL setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public ContainerACL setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public PublicAccessType getPublicAccess() {
        return this.publicAccess;
    }

    public ContainerACL setPublicAccess(PublicAccessType publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public List<SignedIdentifier> getSignedIdentifiers() {
        return this.signedIdentifiers;
    }

    public ContainerACL setSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    public void addSignedIdentifier(String id, Date start, Date expiry, String permission) {
        AccessPolicy accessPolicy = new AccessPolicy();
        accessPolicy.setStart(start);
        accessPolicy.setExpiry(expiry);
        accessPolicy.setPermission(permission);
        SignedIdentifier signedIdentifier = new SignedIdentifier();
        signedIdentifier.setId(id);
        signedIdentifier.setAccessPolicy(accessPolicy);
        this.getSignedIdentifiers().add(signedIdentifier);
    }

    public static enum PublicAccessType {
        NONE,
        BLOBS_ONLY,
        CONTAINER_AND_BLOBS;

    }

    public static class AccessPolicy {
        private Date start;
        private Date expiry;
        private String permission;

        @XmlElement(name="Start")
        @XmlJavaTypeAdapter(value=ContainerACLDateAdapter.class)
        public Date getStart() {
            return this.start;
        }

        public AccessPolicy setStart(Date start) {
            this.start = start;
            return this;
        }

        @XmlElement(name="Expiry")
        @XmlJavaTypeAdapter(value=ContainerACLDateAdapter.class)
        public Date getExpiry() {
            return this.expiry;
        }

        public AccessPolicy setExpiry(Date expiry) {
            this.expiry = expiry;
            return this;
        }

        @XmlElement(name="Permission")
        public String getPermission() {
            return this.permission;
        }

        public AccessPolicy setPermission(String permission) {
            this.permission = permission;
            return this;
        }
    }

    public static class SignedIdentifier {
        private String id;
        private AccessPolicy accessPolicy;

        @XmlElement(name="Id")
        public String getId() {
            return this.id;
        }

        public SignedIdentifier setId(String id) {
            this.id = id;
            return this;
        }

        @XmlElement(name="AccessPolicy")
        public AccessPolicy getAccessPolicy() {
            return this.accessPolicy;
        }

        public SignedIdentifier setAccessPolicy(AccessPolicy accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }
    }

    @XmlRootElement(name="SignedIdentifiers")
    public static class SignedIdentifiers {
        private List<SignedIdentifier> signedIdentifiers = new ArrayList<SignedIdentifier>();

        @XmlElement(name="SignedIdentifier")
        public List<SignedIdentifier> getSignedIdentifiers() {
            return this.signedIdentifiers;
        }

        public void setSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
            this.signedIdentifiers = signedIdentifiers;
        }
    }
}

