/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.entityoperations;

import com.microsoft.windowsazure.core.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionBodyParameterMapper;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public class DefaultEntityActionOperation
implements EntityActionOperation {
    private EntityProxyData proxyData;
    private final EntityOperationBase.EntityUriBuilder uriBuilder;
    private MediaType contentType = MediaType.APPLICATION_JSON_TYPE;
    private MediaType acceptType = MediaType.APPLICATION_ATOM_XML_TYPE;
    private MultivaluedMap<String, String> queryParameters = new MultivaluedMapImpl();
    private final String entityName;
    private final String entityId;
    private final String actionName;
    private Map<String, Object> bodyParameters = new HashMap<String, Object>();

    public DefaultEntityActionOperation(String entityName, String entityId, String actionName) {
        this.entityName = entityName;
        this.entityId = entityId;
        this.actionName = actionName;
        this.uriBuilder = new EntityOperationBase.EntityIdUriBuilder(entityName, entityId).setActionName(actionName);
    }

    @Override
    public void setProxyData(EntityProxyData proxyData) {
        this.proxyData = proxyData;
    }

    protected EntityProxyData getProxyData() {
        return this.proxyData;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getActionName() {
        return this.actionName;
    }

    @Override
    public String getUri() {
        return this.uriBuilder.getUri();
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public DefaultEntityActionOperation addQueryParameter(String key, String value) {
        this.queryParameters.add((Object)key, (Object)value);
        return this;
    }

    @Override
    public Map<String, Object> getBodyParameters() {
        return this.bodyParameters;
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public DefaultEntityActionOperation setContentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public MediaType getAcceptType() {
        return this.acceptType;
    }

    public DefaultEntityActionOperation setAcceptType(MediaType acceptType) {
        this.acceptType = acceptType;
        return this;
    }

    @Override
    public String getVerb() {
        return "POST";
    }

    @Override
    public Object getRequestContents() {
        if (this.bodyParameters.size() == 0) {
            return "";
        }
        String jsonString = "";
        EntityActionBodyParameterMapper mapper = new EntityActionBodyParameterMapper();
        jsonString = mapper.toString(this.bodyParameters);
        return jsonString;
    }

    @Override
    public Object processResponse(Object rawResponse) throws ServiceException {
        PipelineHelpers.throwIfNotSuccess((ClientResponse)((ClientResponse)rawResponse));
        return rawResponse;
    }

    @Override
    public EntityActionOperation addBodyParameter(String key, Object value) {
        this.bodyParameters.put(key, value);
        return this;
    }
}

