/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ServiceFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.exception.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.media.MediaContract;
import com.microsoft.windowsazure.services.media.WritableBlobContainerContract;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityTypeActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.MediaRestProxy;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.LocatorInfo;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MediaExceptionProcessor
implements MediaContract {
    private final MediaContract service;
    private static Log log = LogFactory.getLog(MediaContract.class);

    public MediaExceptionProcessor(MediaContract service) {
        this.service = service;
    }

    @Inject
    public MediaExceptionProcessor(MediaRestProxy service) {
        this.service = service;
    }

    public MediaContract withFilter(ServiceFilter filter) {
        return new MediaExceptionProcessor((MediaContract)this.service.withFilter(filter));
    }

    public MediaContract withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        return new MediaExceptionProcessor((MediaContract)this.service.withRequestFilterFirst(serviceRequestFilter));
    }

    public MediaContract withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        return new MediaExceptionProcessor((MediaContract)this.service.withRequestFilterLast(serviceRequestFilter));
    }

    public MediaContract withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        return new MediaExceptionProcessor((MediaContract)this.service.withResponseFilterFirst(serviceResponseFilter));
    }

    public MediaContract withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        return new MediaExceptionProcessor((MediaContract)this.service.withResponseFilterLast(serviceResponseFilter));
    }

    private ServiceException processCatch(ServiceException e) {
        log.warn((Object)e.getMessage(), e.getCause());
        return ServiceExceptionFactory.process((String)"MediaServices", (ServiceException)e);
    }

    @Override
    public <T> T create(EntityCreateOperation<T> creator) throws ServiceException {
        try {
            return (T)this.service.create(creator);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public <T> T get(EntityGetOperation<T> getter) throws ServiceException {
        try {
            return (T)this.service.get(getter);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public <T> ListResult<T> list(EntityListOperation<T> lister) throws ServiceException {
        try {
            return this.service.list(lister);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void update(EntityUpdateOperation updater) throws ServiceException {
        try {
            this.service.update(updater);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void delete(EntityDeleteOperation deleter) throws ServiceException {
        try {
            this.service.delete(deleter);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void action(EntityActionOperation entityActionOperation) throws ServiceException {
        try {
            this.service.action(entityActionOperation);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public <T> T action(EntityTypeActionOperation<T> entityTypeActionOperation) throws ServiceException {
        try {
            return (T)this.service.action(entityTypeActionOperation);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public WritableBlobContainerContract createBlobWriter(LocatorInfo locator) {
        return this.service.createBlobWriter(locator);
    }
}

