/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.media.implementation.atom.ContentType;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.implementation.atom.LinkType;
import com.microsoft.windowsazure.services.media.implementation.content.Constants;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBElement;

public abstract class ODataEntity<T> {
    private final EntryType entry;
    private final T content;

    protected ODataEntity(EntryType entry, T content) {
        this.entry = entry;
        this.content = content;
    }

    protected ODataEntity(T content) {
        this.content = content;
        ContentType contentElement = new ContentType();
        contentElement.getContent().add(new JAXBElement(Constants.ODATA_PROPERTIES_ELEMENT_NAME, content.getClass(), content));
        this.entry = new EntryType();
        this.entry.getEntryChildren().add(new JAXBElement(Constants.ATOM_CONTENT_ELEMENT_NAME, ContentType.class, (Object)contentElement));
    }

    protected EntryType getEntry() {
        return this.entry;
    }

    protected T getContent() {
        return this.content;
    }

    public boolean hasLink(String rel) {
        return this.getLink(rel) != null;
    }

    public <U extends ODataEntity<?>> LinkInfo<U> getLink(String rel) {
        for (Object child : this.entry.getEntryChildren()) {
            LinkType link = ODataEntity.linkFromChild(child);
            if (link == null || !link.getRel().equals(rel)) continue;
            return new LinkInfo(link);
        }
        return null;
    }

    public <U extends ODataEntity<?>> LinkInfo<U> getRelationLink(String relationName) {
        return this.getLink("http://schemas.microsoft.com/ado/2007/08/dataservices/related/" + relationName);
    }

    private static LinkType linkFromChild(Object child) {
        if (child instanceof JAXBElement) {
            return ODataEntity.linkFromElement((JAXBElement)child);
        }
        return null;
    }

    private static LinkType linkFromElement(JAXBElement element) {
        if (element.getDeclaredType() == LinkType.class) {
            return (LinkType)element.getValue();
        }
        return null;
    }

    public static boolean isODataEntityType(Class<?> type) {
        return ODataEntity.class.isAssignableFrom(type);
    }

    public static boolean isODataEntityCollectionType(Class<?> type, Type genericType) {
        if (ListResult.class != type) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        if (pt.getActualTypeArguments().length != 1) {
            return false;
        }
        Class<?> typeClass = ODataEntity.getCollectedType(genericType);
        return ODataEntity.isODataEntityType(typeClass);
    }

    public static Class<?> getCollectedType(Type genericType) {
        ParameterizedType pt = (ParameterizedType)genericType;
        if (pt.getActualTypeArguments().length != 1) {
            throw new IllegalArgumentException("genericType");
        }
        return (Class)pt.getActualTypeArguments()[0];
    }
}

