/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.core.pipeline.jersey.IdempotentClientFilter;
import com.microsoft.windowsazure.services.media.implementation.ResourceLocationManager;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.net.URISyntaxException;

public class RedirectFilter
extends IdempotentClientFilter {
    private final ResourceLocationManager locationManager;

    public RedirectFilter(ResourceLocationManager locationManager) {
        this.locationManager = locationManager;
    }

    public ClientResponse doHandle(ClientRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request should not be null");
        }
        URI originalURI = request.getURI();
        request.setURI(this.locationManager.getRedirectedURI(originalURI));
        ClientResponse response = this.getNext().handle(request);
        while (response.getClientResponseStatus() == ClientResponse.Status.MOVED_PERMANENTLY) {
            try {
                this.locationManager.setRedirectedURI((String)response.getHeaders().getFirst((Object)"Location"));
            }
            catch (NullPointerException e) {
                throw new ClientHandlerException("HTTP Redirect did not include Location header");
            }
            catch (URISyntaxException e) {
                throw new ClientHandlerException("HTTP Redirect location is not a valid URI");
            }
            request.setURI(this.locationManager.getRedirectedURI(originalURI));
            response = this.getNext().handle(request);
        }
        return response;
    }

    public URI getBaseURI() {
        return this.locationManager.getBaseURI();
    }
}

