/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.implementation.content.AccessPolicyType;
import com.microsoft.windowsazure.services.media.models.AccessPolicyInfo;
import com.microsoft.windowsazure.services.media.models.AccessPolicyPermission;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import java.util.EnumSet;

public final class AccessPolicy {
    private static final String ENTITY_SET = "AccessPolicies";

    private AccessPolicy() {
    }

    public static EntityCreateOperation<AccessPolicyInfo> create(String name, double durationInMinutes, EnumSet<AccessPolicyPermission> permissions) {
        return new Creator(name, durationInMinutes, permissions);
    }

    public static EntityGetOperation<AccessPolicyInfo> get(String accessPolicyId) {
        return new DefaultGetOperation<AccessPolicyInfo>(ENTITY_SET, accessPolicyId, AccessPolicyInfo.class);
    }

    public static EntityGetOperation<AccessPolicyInfo> get(LinkInfo<AccessPolicyInfo> link) {
        return new DefaultGetOperation<AccessPolicyInfo>(link.getHref(), AccessPolicyInfo.class);
    }

    public static DefaultListOperation<AccessPolicyInfo> list() {
        return new DefaultListOperation<AccessPolicyInfo>(ENTITY_SET, new GenericType<ListResult<AccessPolicyInfo>>(){});
    }

    public static EntityDeleteOperation delete(String accessPolicyId) {
        return new DefaultDeleteOperation(ENTITY_SET, accessPolicyId);
    }

    private static class Creator
    extends EntityOperationSingleResultBase<AccessPolicyInfo>
    implements EntityCreateOperation<AccessPolicyInfo> {
        private final String policyName;
        private final double durationInMinutes;
        private final EnumSet<AccessPolicyPermission> permissions;

        public Creator(String policyName, double durationInMinutes, EnumSet<AccessPolicyPermission> permissions) {
            super(AccessPolicy.ENTITY_SET, AccessPolicyInfo.class);
            this.policyName = policyName;
            this.durationInMinutes = durationInMinutes;
            this.permissions = permissions;
        }

        @Override
        public Object getRequestContents() {
            return new AccessPolicyType().setName(this.policyName).setDurationInMinutes(this.durationInMinutes).setPermissions(AccessPolicyPermission.bitsFromPermissions(this.permissions));
        }
    }
}

