/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.AffinityGroupOperations;
import com.microsoft.windowsazure.management.ManagementClientImpl;
import com.microsoft.windowsazure.management.models.AffinityGroupCreateParameters;
import com.microsoft.windowsazure.management.models.AffinityGroupGetResponse;
import com.microsoft.windowsazure.management.models.AffinityGroupListResponse;
import com.microsoft.windowsazure.management.models.AffinityGroupUpdateParameters;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AffinityGroupOperationsImpl
implements ServiceOperations<ManagementClientImpl>,
AffinityGroupOperations {
    private ManagementClientImpl client;

    AffinityGroupOperationsImpl(ManagementClientImpl client) {
        this.client = client;
    }

    public ManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> createAsync(final AffinityGroupCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return AffinityGroupOperationsImpl.this.create(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse create(AffinityGroupCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, AffinityGroupCreateParameters> tracingParameters = new HashMap<String, AffinityGroupCreateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/affinitygroups";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element createAffinityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateAffinityGroup");
        requestDoc.appendChild(createAffinityGroupElement);
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        createAffinityGroupElement.appendChild(nameElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        createAffinityGroupElement.appendChild(labelElement);
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            createAffinityGroupElement.appendChild(descriptionElement);
        }
        Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
        locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
        createAffinityGroupElement.appendChild(locationElement);
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 201) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String affinityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return AffinityGroupOperationsImpl.this.delete(affinityGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String affinityGroupName) throws IOException, ServiceException {
        if (affinityGroupName == null) {
            throw new NullPointerException("affinityGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("affinityGroupName", affinityGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/affinitygroups/" + affinityGroupName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AffinityGroupGetResponse> getAsync(final String affinityGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<AffinityGroupGetResponse>(){

            @Override
            public AffinityGroupGetResponse call() throws Exception {
                return AffinityGroupOperationsImpl.this.get(affinityGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffinityGroupGetResponse get(String affinityGroupName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        if (affinityGroupName == null) {
            throw new NullPointerException("affinityGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("affinityGroupName", affinityGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/affinitygroups/" + affinityGroupName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            AffinityGroupGetResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new AffinityGroupGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup");
            if (affinityGroupElement != null) {
                Element capabilitiesSequenceElement;
                Element storageServicesSequenceElement;
                Element hostedServicesSequenceElement;
                Element locationElement;
                Element descriptionElement;
                Element labelElement;
                Element nameElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                if (nameElement != null) {
                    String nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                if ((labelElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                    String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                    result.setLabel(labelInstance);
                }
                if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                    String descriptionInstance = descriptionElement.getTextContent();
                    result.setDescription(descriptionInstance);
                }
                if ((locationElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                    String locationInstance = locationElement.getTextContent();
                    result.setLocation(locationInstance);
                }
                if ((hostedServicesSequenceElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedServices")) != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)hostedServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedService").size(); ++i1) {
                        Element serviceNameElement;
                        Element hostedServicesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)hostedServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostedService").get(i1);
                        AffinityGroupGetResponse.HostedServiceReference hostedServiceInstance = new AffinityGroupGetResponse.HostedServiceReference();
                        result.getHostedServices().add(hostedServiceInstance);
                        Element urlElement = XmlUtility.getElementByTagNameNS((Node)hostedServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                        if (urlElement != null) {
                            URI urlInstance = new URI(urlElement.getTextContent());
                            hostedServiceInstance.setUri(urlInstance);
                        }
                        if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)hostedServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) == null) continue;
                        String serviceNameInstance = serviceNameElement.getTextContent();
                        hostedServiceInstance.setServiceName(serviceNameInstance);
                    }
                }
                if ((storageServicesSequenceElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageServices")) != null) {
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)storageServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService").size(); ++i2) {
                        Element serviceNameElement2;
                        Element storageServicesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)storageServicesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"StorageService").get(i2);
                        AffinityGroupGetResponse.StorageServiceReference storageServiceInstance = new AffinityGroupGetResponse.StorageServiceReference();
                        result.getStorageServices().add(storageServiceInstance);
                        Element urlElement2 = XmlUtility.getElementByTagNameNS((Node)storageServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Url");
                        if (urlElement2 != null) {
                            URI urlInstance2 = new URI(urlElement2.getTextContent());
                            storageServiceInstance.setUri(urlInstance2);
                        }
                        if ((serviceNameElement2 = XmlUtility.getElementByTagNameNS((Node)storageServicesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) == null) continue;
                        String serviceNameInstance2 = serviceNameElement2.getTextContent();
                        storageServiceInstance.setServiceName(serviceNameInstance2);
                    }
                }
                if ((capabilitiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Capabilities")) != null) {
                    for (int i3 = 0; i3 < XmlUtility.getElementsByTagNameNS((Node)capabilitiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Capability").size(); ++i3) {
                        Element capabilitiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)capabilitiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Capability").get(i3);
                        result.getCapabilities().add(capabilitiesElement.getTextContent());
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AffinityGroupGetResponse affinityGroupGetResponse = result;
            return affinityGroupGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AffinityGroupListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<AffinityGroupListResponse>(){

            @Override
            public AffinityGroupListResponse call() throws Exception {
                return AffinityGroupOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffinityGroupListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/affinitygroups";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            AffinityGroupListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new AffinityGroupListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element affinityGroupsSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroups");
            if (affinityGroupsSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)affinityGroupsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup").size(); ++i1) {
                    Element capabilitiesSequenceElement;
                    Element locationElement;
                    Element descriptionElement;
                    Element labelElement;
                    Element affinityGroupsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)affinityGroupsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup").get(i1);
                    AffinityGroupListResponse.AffinityGroup affinityGroupInstance = new AffinityGroupListResponse.AffinityGroup();
                    result.getAffinityGroups().add(affinityGroupInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        affinityGroupInstance.setName(nameInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode((String)labelElement.getTextContent())) : null;
                        affinityGroupInstance.setLabel(labelInstance);
                    }
                    if ((descriptionElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Description")) != null) {
                        String descriptionInstance = descriptionElement.getTextContent();
                        affinityGroupInstance.setDescription(descriptionInstance);
                    }
                    if ((locationElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Location")) != null) {
                        String locationInstance = locationElement.getTextContent();
                        affinityGroupInstance.setLocation(locationInstance);
                    }
                    if ((capabilitiesSequenceElement = XmlUtility.getElementByTagNameNS((Node)affinityGroupsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Capabilities")) == null) continue;
                    for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)capabilitiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Capability").size(); ++i2) {
                        Element capabilitiesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)capabilitiesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Capability").get(i2);
                        affinityGroupInstance.getCapabilities().add(capabilitiesElement.getTextContent());
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            AffinityGroupListResponse affinityGroupListResponse = result;
            return affinityGroupListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> updateAsync(final String affinityGroupName, final AffinityGroupUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return AffinityGroupOperationsImpl.this.update(affinityGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse update(String affinityGroupName, AffinityGroupUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (affinityGroupName == null) {
            throw new NullPointerException("affinityGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("affinityGroupName", affinityGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/affinitygroups/" + affinityGroupName.trim();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element updateAffinityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateAffinityGroup");
        requestDoc.appendChild(updateAffinityGroupElement);
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getLabel().getBytes())));
        updateAffinityGroupElement.appendChild(labelElement);
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            updateAffinityGroupElement.appendChild(descriptionElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

