/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.NetworkManagementClientImpl;
import com.microsoft.windowsazure.management.network.StaticIPOperations;
import com.microsoft.windowsazure.management.network.models.NetworkStaticIPAvailabilityResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StaticIPOperationsImpl
implements ServiceOperations<NetworkManagementClientImpl>,
StaticIPOperations {
    private NetworkManagementClientImpl client;

    StaticIPOperationsImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }

    public NetworkManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<NetworkStaticIPAvailabilityResponse> checkAsync(final String networkName, final InetAddress ipAddress) {
        return this.getClient().getExecutorService().submit(new Callable<NetworkStaticIPAvailabilityResponse>(){

            @Override
            public NetworkStaticIPAvailabilityResponse call() throws Exception {
                return StaticIPOperationsImpl.this.check(networkName, ipAddress);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStaticIPAvailabilityResponse check(String networkName, InetAddress ipAddress) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        if (networkName == null) {
            throw new NullPointerException("networkName");
        }
        if (ipAddress == null) {
            throw new NullPointerException("ipAddress");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("networkName", networkName);
            tracingParameters.put("ipAddress", ipAddress);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"checkAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/networking/" + networkName.trim() + "?";
        url = url + "op=checkavailability";
        url = url + "&" + "address=" + URLEncoder.encode(ipAddress.getHostAddress(), "UTF-8");
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2013-11-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            NetworkStaticIPAvailabilityResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new NetworkStaticIPAvailabilityResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element addressAvailabilityResponseElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"AddressAvailabilityResponse");
            if (addressAvailabilityResponseElement != null) {
                Element availableAddressesSequenceElement;
                Element isAvailableElement = XmlUtility.getElementByTagNameNS((Node)addressAvailabilityResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"IsAvailable");
                if (isAvailableElement != null) {
                    boolean isAvailableInstance = DatatypeConverter.parseBoolean((String)isAvailableElement.getTextContent().toLowerCase());
                    result.setIsAvailable(isAvailableInstance);
                }
                if ((availableAddressesSequenceElement = XmlUtility.getElementByTagNameNS((Node)addressAvailabilityResponseElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailableAddresses")) != null) {
                    for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)availableAddressesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailableAddress").size(); ++i1) {
                        Element availableAddressesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)availableAddressesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AvailableAddress").get(i1);
                        result.getAvailableAddresses().add(InetAddress.getByName(availableAddressesElement.getTextContent()));
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            NetworkStaticIPAvailabilityResponse networkStaticIPAvailabilityResponse = result;
            return networkStaticIPAvailabilityResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

