/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.bean;

import com.clustercontrol.cloud.IResourceManagement;
import java.util.ArrayList;
import java.util.List;

public class AzurePendingInstances {
    private static AzurePendingInstances instance;
    private List<AzurePendingInstanceInfo> azureInstances = new ArrayList<AzurePendingInstanceInfo>();

    private AzurePendingInstances() {
        instance = null;
    }

    public static AzurePendingInstances getInstance() {
        if (instance == null) {
            instance = new AzurePendingInstances();
        }
        return instance;
    }

    public void addAzureInstance(IResourceManagement.Instance azureInstance, String regionName, String accessKey) {
        AzurePendingInstanceInfo azurePendingInstanceInfo = new AzurePendingInstanceInfo();
        azurePendingInstanceInfo.setAzureInstance(azureInstance);
        azurePendingInstanceInfo.setRegionName(regionName);
        azurePendingInstanceInfo.setAccessKey(accessKey);
        this.azureInstances.add(azurePendingInstanceInfo);
    }

    public IResourceManagement.Instance getAzureInstance(String instanceID, String regionName, String accessKey) {
        for (AzurePendingInstanceInfo azureInstance : this.azureInstances) {
            if (!azureInstance.getRegionName().equals(regionName) || !azureInstance.getAccessKey().equals(accessKey) || !azureInstance.getAzureInstance().getInstanceId().equals(instanceID)) continue;
            return azureInstance.getAzureInstance();
        }
        return null;
    }

    public void removeAzureInstance(String instanceID, String regionName, String accessKey) {
        for (AzurePendingInstanceInfo azureInstance : this.azureInstances) {
            if (!azureInstance.getAzureInstance().getInstanceId().equals(instanceID) || !azureInstance.getAccessKey().equals(accessKey) || !azureInstance.getRegionName().equals(regionName)) continue;
            this.azureInstances.remove(azureInstance);
            return;
        }
    }

    public List<IResourceManagement.Instance> getAzureInstances(String regionName, String accessKey) {
        ArrayList<IResourceManagement.Instance> instances = new ArrayList<IResourceManagement.Instance>();
        for (AzurePendingInstanceInfo azureInstance : this.azureInstances) {
            if (!azureInstance.getAccessKey().equals(accessKey) || !azureInstance.getRegionName().equals(regionName)) continue;
            instances.add(azureInstance.getAzureInstance());
        }
        return instances;
    }

    public boolean isExist(String instanceID, String regionName, String accessKey) {
        boolean isExist = false;
        for (AzurePendingInstanceInfo azureInstance : this.azureInstances) {
            if (!azureInstance.getAzureInstance().getInstanceId().equals(instanceID) || !azureInstance.getAccessKey().equals(accessKey) || !azureInstance.getRegionName().equals(regionName)) continue;
            isExist = true;
        }
        return isExist;
    }

    private class AzurePendingInstanceInfo {
        IResourceManagement.Instance azureInstance = new IResourceManagement.Instance();
        String regionName = "";
        String accessKey = "";

        private AzurePendingInstanceInfo() {
        }

        public String getRegionName() {
            return this.regionName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public IResourceManagement.Instance getAzureInstance() {
            return this.azureInstance;
        }

        public void setAzureInstance(IResourceManagement.Instance azureInstance) {
            this.azureInstance = azureInstance;
        }
    }
}

