/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.factory.ListBlobsResult;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.BlobService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class AzureDeleteStorageBackup
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private String storageBackupId = null;
    private Configuration config = null;

    public AzureDeleteStorageBackup(Configuration config, String storageBackupId) {
        this.config = config;
        this.storageBackupId = storageBackupId;
    }

    @Override
    public void execute() throws CloudManagerFault {
        StorageAccountOperations storageAccountOperations = null;
        AzureUtil.AzureServiceRequestFilter request_find = null;
        AzureUtil.AzureServiceResponseFilter response_find = null;
        try {
            this.logger.info((Object)("AzureDeleteStorageBackup start: " + this.storageBackupId));
            String snapshotID = "";
            String storageAccountName = this.storageBackupId.substring(0, this.storageBackupId.indexOf("_"));
            String containerName = this.storageBackupId.substring(this.storageBackupId.indexOf("_") + 1);
            containerName = containerName.substring(0, containerName.indexOf("_"));
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)this.config);
            storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            snapshotID = AzureUtil.getConvertSnapshotValue(this.storageBackupId.substring(this.storageBackupId.lastIndexOf("_") + 1));
            Configuration blobconfig = null;
            blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
            request_find = new AzureUtil.AzureServiceRequestFilter();
            response_find = new AzureUtil.AzureServiceResponseFilter();
            request_find.changeURL("?", containerName + "?restype=container&include=snapshots&");
            response_find.setUseBody();
            BlobContract blobContract_find = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request_find)).withResponseFilterLast((ServiceResponseFilter)response_find);
            blobContract_find.listContainers();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ListBlobsResult.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ListBlobsResult listBlobsResult = (ListBlobsResult)jaxbUnmarshaller.unmarshal(response_find.getInputStream());
            response_find.close();
            for (ListBlobsResult.Blob blob : listBlobsResult.getBlobs()) {
                if (blob.getSnapshot() == null || !blob.getSnapshot().equals(snapshotID)) continue;
                AzureUtil.AzureServiceRequestFilter request_del = new AzureUtil.AzureServiceRequestFilter();
                AzureUtil.AzureServiceResponseFilter response_del = new AzureUtil.AzureServiceResponseFilter();
                request_del.changeURL(blob.getName(), blob.getName() + "?snapshot=" + snapshotID);
                BlobContract blobContract_del = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request_del)).withResponseFilterLast((ServiceResponseFilter)response_del);
                this.logger.info((Object)("BlobContract.deleteBlob(" + containerName + "," + blob.getName() + ",snapshot=" + snapshotID + ")"));
                blobContract_del.deleteBlob(containerName, blob.getName());
                response_del.close();
                this.logger.info((Object)"Deleting Storage backup is success...");
                break;
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)"Deleting Storage backup is failed...");
            this.logger.error((Object)("AzureDeleteStorageBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
            this.putLog("DeleteStorageBackup", "DeleteStorageBackup was failed", e.getMessage());
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Deleting Storage backup is failed...");
            this.logger.error((Object)("AzureDeleteStorageBackup: " + e.getMessage()));
            this.putLog("DeleteStorageBackup", "DeleteStorageBackup was failed", e.getMessage());
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            this.logger.info((Object)("AzureDeleteStorageBackup end: " + this.storageBackupId));
            if (response_find != null) {
                response_find.close();
                response_find = null;
            }
        }
    }
}

