/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.TransactionException;
import com.clustercontrol.cloud.util.HinemosUtil;
import com.clustercontrol.fault.FacilityDuplicate;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.UsedFacility;
import com.clustercontrol.repository.bean.AgentStatusInfo;
import com.clustercontrol.repository.bean.FacilityInfo;
import com.clustercontrol.repository.bean.FacilityTreeItem;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.RepositoryTableInfo;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.entity.CollectorPlatformMstData;
import com.clustercontrol.repository.entity.CollectorSubPlatformMstData;
import com.clustercontrol.repository.model.CollectorPlatformMstEntity;
import com.clustercontrol.repository.model.CollectorSubPlatformMstEntity;
import com.clustercontrol.repository.model.FacilityEntity;
import com.clustercontrol.repository.model.NodeEntity;
import com.clustercontrol.repository.session.RepositoryControllerBean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityExistsException;

public class RepositoryControllerBeanWrapper
extends RepositoryControllerBean {
    private static ThreadLocal<RepositoryControllerBeanWrapper> instance = new ThreadLocal<RepositoryControllerBeanWrapper>(){

        @Override
        protected RepositoryControllerBeanWrapper initialValue() {
            return null;
        }
    };

    private RepositoryControllerBeanWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScope(final String parentFacilityId, final ScopeInfo property) throws FacilityDuplicate, InvalidSetting, InvalidRole, HinemosUnknown {
        Class<RepositoryControllerBeanWrapper> clazz = RepositoryControllerBeanWrapper.class;
        synchronized (RepositoryControllerBeanWrapper.class) {
            try {
                this.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        RepositoryControllerBean bean = new RepositoryControllerBean();
                        try {
                            if (bean.getScope(property.getFacilityId()) != null) {
                                FacilityDuplicate exception = new FacilityDuplicate();
                                exception.setFacilityId(property.getFacilityId());
                                throw exception;
                            }
                        }
                        catch (FacilityNotFound facilityNotFound) {
                            // empty catch block
                        }
                        bean.addScope(parentFacilityId, property);
                        return null;
                    }
                });
                SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                    @Override
                    public void rollback() throws TransactionException {
                        try {
                            RepositoryControllerBeanWrapper.this.execute(new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    new RepositoryControllerBean().deleteScope(property.getFacilityId());
                                    return null;
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new InternalManagerError(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof FacilityDuplicate) {
                    throw new FacilityDuplicate(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof InvalidSetting) {
                    throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof HinemosUnknown) {
                    throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
                }
                throw new InternalManagerError(e);
            }
            catch (Exception e) {
                throw new InternalManagerError(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignNodeScope(final String parentFacilityId, final String[] facilityIds) throws InvalidSetting, InvalidRole, HinemosUnknown {
        Class<RepositoryControllerBeanWrapper> clazz = RepositoryControllerBeanWrapper.class;
        synchronized (RepositoryControllerBeanWrapper.class) {
            try {
                this.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        new RepositoryControllerBean().assignNodeScope(parentFacilityId, facilityIds);
                        return null;
                    }
                });
                SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                    @Override
                    public void rollback() throws TransactionException {
                        try {
                            RepositoryControllerBeanWrapper.this.execute(new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    new RepositoryControllerBean().releaseNodeScope(parentFacilityId, facilityIds);
                                    return null;
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new InternalManagerError(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof InvalidSetting) {
                    throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof HinemosUnknown) {
                    throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
                }
                throw new InternalManagerError(e);
            }
            catch (Exception e) {
                throw new InternalManagerError(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(final NodeInfo nodeInfo) throws FacilityDuplicate, InvalidSetting, HinemosUnknown {
        Class<RepositoryControllerBeanWrapper> clazz = RepositoryControllerBeanWrapper.class;
        synchronized (RepositoryControllerBeanWrapper.class) {
            try {
                this.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        RepositoryControllerBean bean = new RepositoryControllerBean();
                        try {
                            if (bean.getNode(nodeInfo.getFacilityId()) != null) {
                                FacilityDuplicate exception = new FacilityDuplicate();
                                exception.setFacilityId(nodeInfo.getFacilityId());
                                throw exception;
                            }
                        }
                        catch (FacilityNotFound facilityNotFound) {
                            // empty catch block
                        }
                        bean.addNode(nodeInfo);
                        return null;
                    }
                });
                SessionService.current().addRollbackAction(new SessionService.RolebackAction(){

                    @Override
                    public void rollback() throws TransactionException {
                        try {
                            RepositoryControllerBeanWrapper.this.execute(new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    new RepositoryControllerBean().deleteNode(nodeInfo.getFacilityId());
                                    return null;
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new TransactionException((Throwable)e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new InternalManagerError(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FacilityDuplicate) {
                    throw new FacilityDuplicate(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof InvalidSetting) {
                    throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof HinemosUnknown) {
                    throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
                }
                throw new InternalManagerError(e);
            }
            catch (Exception e) {
                throw new InternalManagerError(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyNode(final NodeInfo info) throws InvalidSetting, InvalidRole, HinemosUnknown {
        Class<RepositoryControllerBeanWrapper> clazz = RepositoryControllerBeanWrapper.class;
        synchronized (RepositoryControllerBeanWrapper.class) {
            try {
                this.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        new RepositoryControllerBean().modifyNode(info);
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                throw new InternalManagerError(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof InvalidSetting) {
                    throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof HinemosUnknown) {
                    throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
                }
                throw new InternalManagerError(e);
            }
            catch (Exception e) {
                throw new InternalManagerError(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(final String facilityId) throws UsedFacility, InvalidRole, HinemosUnknown {
        Class<RepositoryControllerBeanWrapper> clazz = RepositoryControllerBeanWrapper.class;
        synchronized (RepositoryControllerBeanWrapper.class) {
            try {
                this.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        new RepositoryControllerBean().deleteNode(facilityId);
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                throw new InternalManagerError(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof InvalidRole) {
                    throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof UsedFacility) {
                    throw new UsedFacility(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof HinemosUnknown) {
                    throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
                }
                throw new InternalManagerError(e);
            }
            catch (Exception e) {
                throw new InternalManagerError(e);
            }
            return;
        }
    }

    public NodeInfo getNode(final String facilityId) throws FacilityNotFound, HinemosUnknown {
        try {
            return this.execute(new Callable<NodeInfo>(){

                @Override
                public NodeInfo call() throws Exception {
                    return new RepositoryControllerBean().getNode(facilityId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FacilityNotFound) {
                throw new FacilityNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteScope(final String facilityId) throws UsedFacility, InvalidRole, HinemosUnknown {
        Class<RepositoryControllerBeanWrapper> clazz = RepositoryControllerBeanWrapper.class;
        synchronized (RepositoryControllerBeanWrapper.class) {
            try {
                this.execute(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        new RepositoryControllerBean().deleteScope(facilityId);
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                throw new InternalManagerError(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UsedFacility) {
                    throw new UsedFacility(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof InvalidRole) {
                    throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
                }
                if (e.getCause() instanceof HinemosUnknown) {
                    throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
                }
                throw new InternalManagerError(e);
            }
            catch (Exception e) {
                throw new InternalManagerError(e);
            }
            return;
        }
    }

    private <T> T execute(Callable<T> task) throws Exception {
        return HinemosUtil.submit(task).get();
    }

    public static RepositoryControllerBeanWrapper bean() {
        RepositoryControllerBeanWrapper bean = instance.get();
        if (bean == null) {
            bean = new RepositoryControllerBeanWrapper();
            instance.set(bean);
        }
        return bean;
    }

    public FacilityEntity getFacilityEntityByPK(final String facilityId) throws FacilityNotFound, InvalidRole, HinemosUnknown {
        try {
            return this.execute(new Callable<FacilityEntity>(){

                @Override
                public FacilityEntity call() throws Exception {
                    return new RepositoryControllerBean().getFacilityEntityByPK(facilityId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FacilityNotFound) {
                throw new FacilityNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public NodeEntity getNodeEntityByPK(String facilityId) throws FacilityNotFound, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void addCollectorPratformMst(CollectorPlatformMstData data) throws EntityExistsException, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void addCollectorSubPlatformMst(CollectorSubPlatformMstData data) throws EntityExistsException, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void deleteCollectorPratformMst(String platformId) throws FacilityNotFound, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void deleteCollectorSubPratformMst(String subPlatformId) throws FacilityNotFound, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public List<CollectorPlatformMstEntity> getCollectorPlatformMstList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public List<CollectorSubPlatformMstEntity> getCollectorSubPlatformMstList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public FacilityTreeItem getFacilityTree(final String ownerRoleId, final Locale locale) throws HinemosUnknown {
        try {
            return this.execute(new Callable<FacilityTreeItem>(){

                @Override
                public FacilityTreeItem call() throws Exception {
                    return new RepositoryControllerBean().getFacilityTree(ownerRoleId, locale);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public FacilityTreeItem getExecTargetFacilityTree(String facilityId, String ownerRoleId, Locale locale) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public FacilityTreeItem getNodeFacilityTree(Locale locale, String ownerRoleId) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public List<NodeInfo> getNodeDetailList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<NodeInfo> getFilterNodeList(NodeInfo property) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getExecTargetFacilityIdList(String facilityId, String ownerRoleId) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getNodeFacilityIdList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getNodeFacilityIdList(boolean sort) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public String getFacilityPath(final String facilityId, final String parentFacilityId) throws HinemosUnknown {
        try {
            return this.execute(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return new RepositoryControllerBean().getFacilityPath(facilityId, parentFacilityId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public NodeInfo getNodePropertyBySNMP(String ipAddress, int port, String community, String version) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public List<String> getFacilityIdByIpAddress(InetAddress ipaddr) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getFacilityIdList(String hostName, String ipAddress) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void addNode(NodeInfo info, boolean topicSendFlg) throws FacilityDuplicate, InvalidSetting, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<FacilityInfo> getFacilityList(final String parentFacilityId) throws HinemosUnknown {
        try {
            return this.execute(new Callable<ArrayList<FacilityInfo>>(){

                @Override
                public ArrayList<FacilityInfo> call() throws Exception {
                    RepositoryControllerBean bean = new RepositoryControllerBean();
                    ArrayList nodes = bean.getNodeList(parentFacilityId, Integer.MAX_VALUE);
                    ArrayList scopes = bean.getFacilityList(parentFacilityId);
                    ArrayList<FacilityInfo> facilities = new ArrayList<FacilityInfo>();
                    facilities.addAll(nodes);
                    facilities.addAll(scopes);
                    return facilities;
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public ScopeInfo getScope(final String facilityId) throws FacilityNotFound, HinemosUnknown, InvalidRole {
        try {
            return this.execute(new Callable<ScopeInfo>(){

                @Override
                public ScopeInfo call() throws Exception {
                    new RepositoryControllerBean().getScope(facilityId);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof FacilityNotFound) {
                throw new FacilityNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void addScope(String parentFacilityId, ScopeInfo property, int displaySortOrder) throws FacilityDuplicate, InvalidSetting, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void addScope(String parentFacilityId, ScopeInfo info, int displaySortOrder, boolean topicSendFlg) throws FacilityDuplicate, InvalidSetting, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void modifyScope(ScopeInfo info) throws InvalidSetting, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<NodeInfo> getNodeList(String parentFacilityId, int level) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getNodeScopeList(String facilityId) throws InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getFacilityIdList(String parentFacilityId, int level) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getFacilityIdList(String parentFacilityId, int level, boolean scopeFlag) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getFacilityIdList(String parentFacilityId, int level, boolean sort, boolean scopeFlag) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getNodeFacilityIdList(String parentFacilityId, String ownerRoleId, int level) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getNodeFacilityIdList(String parentFacilityId, String ownerRoleId, int level, boolean sort, Boolean valid) throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void assignNodeScope(String parentFacilityId, String[] facilityIds, boolean topicSendFlg) throws InvalidSetting, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void releaseNodeScope(final String parentFacilityId, final String[] facilityIds) throws InvalidSetting, InvalidRole, HinemosUnknown {
        try {
            this.execute(new Callable<ScopeInfo>(){

                @Override
                public ScopeInfo call() throws Exception {
                    new RepositoryControllerBean().releaseNodeScope(parentFacilityId, facilityIds);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidSetting) {
                throw new InvalidSetting(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public void releaseNodeScope(String parentFacilityId, String[] facilityIds, boolean topicSendFlg) throws InvalidSetting, InvalidRole, HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public boolean isNode(final String facilityId) throws FacilityNotFound, InvalidRole, HinemosUnknown {
        try {
            return this.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return new RepositoryControllerBean().isNode(facilityId);
                }
            });
        }
        catch (InterruptedException e) {
            throw new InternalManagerError(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FacilityNotFound) {
                throw new FacilityNotFound(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof InvalidRole) {
                throw new InvalidRole(e.getCause().getMessage(), (Throwable)e);
            }
            if (e.getCause() instanceof HinemosUnknown) {
                throw new HinemosUnknown(e.getCause().getMessage(), (Throwable)e);
            }
            throw new InternalManagerError(e);
        }
        catch (Exception e) {
            throw new InternalManagerError(e);
        }
    }

    public String getSeparator() {
        throw new UnsupportedOperationException();
    }

    public void sendRepositoryUpdateTopic() {
        throw new UnsupportedOperationException();
    }

    public ArrayList<RepositoryTableInfo> getPlatformList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<RepositoryTableInfo> getHostList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public List<NodeInfo> getOpenFlowSwitchList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<RepositoryTableInfo> getCollectorSubPlatformTableInfoList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> getVmProtocolMstList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public Date getLastUpdate() {
        throw new UnsupportedOperationException();
    }

    public ArrayList<AgentStatusInfo> getAgentStatusList() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void restartAgent(ArrayList<String> facilityIdList, int agentCommand) {
        throw new UnsupportedOperationException();
    }

    public HashMap<String, String> getAgentLibMap() throws HinemosUnknown {
        throw new UnsupportedOperationException();
    }

    public void checkIsUseFacility(String facilityId) throws HinemosUnknown, UsedFacility {
        throw new UnsupportedOperationException();
    }

    public Set<String> getNodeListByNodename(String hostname) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getNodeListByIpAddress(InetAddress ipAddress) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getNodeListByHostname(String hostname) {
        throw new UnsupportedOperationException();
    }

    public boolean containsFaciliyId(String scopeFacilityId, String nodeFacilityId, String ownerRoleId) {
        throw new UnsupportedOperationException();
    }
}

