/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.SnippetType;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.PathWithLines;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.ColorAware;
import cucumber.runtime.formatter.FormatterFactory;
import cucumber.runtime.formatter.StrictAware;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.util.FixJava;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuntimeOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE = FixJava.readResource((String)"/cucumber/runtime/USAGE.txt");
    private static final Pattern SHELLWORDS_PATTERN = Pattern.compile("[^\\s']+|'([^']*)'");
    private final List<String> glue = new ArrayList<String>();
    private final List<Object> filters = new ArrayList<Object>();
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<String> featurePaths = new ArrayList<String>();
    private final FormatterFactory formatterFactory;
    private URL dotCucumber;
    private boolean dryRun;
    private boolean strict = false;
    private boolean monochrome = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;

    public RuntimeOptions(Env env, String ... argv) {
        this(env, new FormatterFactory(), argv);
    }

    RuntimeOptions(Env env, FormatterFactory formatterFactory, String ... argv) {
        this.formatterFactory = formatterFactory;
        this.parse(new ArrayList<String>(Arrays.asList(argv)), false);
        String cucumberOptionsFromEnv = env.get("cucumber.options");
        if (cucumberOptionsFromEnv != null) {
            this.parse(this.shellWords(cucumberOptionsFromEnv), true);
        }
        if (this.formatters.isEmpty()) {
            this.formatters.add(formatterFactory.create("progress"));
        }
        this.setFormatterOptions();
    }

    private List<String> shellWords(String cmdline) {
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher shellwordsMatcher = SHELLWORDS_PATTERN.matcher(cmdline);
        while (shellwordsMatcher.find()) {
            if (shellwordsMatcher.group(1) != null) {
                matchList.add(shellwordsMatcher.group(1));
                continue;
            }
            matchList.add(shellwordsMatcher.group());
        }
        return matchList;
    }

    private void parse(List<String> args, boolean clobberFeaturePathsAndGlue) {
        ArrayList<Object> parsedFilters = new ArrayList<Object>();
        ArrayList<String> oldFeaturePaths = new ArrayList<String>(this.featurePaths);
        ArrayList<String> oldGlue = new ArrayList<String>(this.glue);
        if (clobberFeaturePathsAndGlue) {
            this.featurePaths.clear();
            this.glue.clear();
        }
        while (!args.isEmpty()) {
            String nextArg;
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                this.glue.add(gluePath);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedFilters.add(args.remove(0));
                continue;
            }
            if (arg.equals("--format") || arg.equals("-f")) {
                this.formatters.add(this.formatterFactory.create(args.remove(0)));
                continue;
            }
            if (arg.equals("--dotcucumber")) {
                String urlOrPath = args.remove(0);
                this.dotCucumber = Utils.toURL(urlOrPath);
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                this.strict = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-monochrome") || arg.equals("--monochrome") || arg.equals("-m")) {
                this.monochrome = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--snippets")) {
                nextArg = args.remove(0);
                this.snippetType = SnippetType.fromString(nextArg);
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                nextArg = args.remove(0);
                Pattern patternFilter = Pattern.compile(nextArg);
                parsedFilters.add(patternFilter);
                continue;
            }
            if (arg.startsWith("-")) {
                this.printUsage();
                throw new CucumberException("Unknown option: " + arg);
            }
            PathWithLines pathWithLines = new PathWithLines(arg);
            this.featurePaths.add(pathWithLines.path);
            parsedFilters.addAll(pathWithLines.lines);
        }
        if (!parsedFilters.isEmpty()) {
            this.filters.clear();
            this.filters.addAll(parsedFilters);
        }
        if (this.featurePaths.isEmpty()) {
            this.featurePaths.addAll(oldFeaturePaths);
        }
        if (this.glue.isEmpty()) {
            this.glue.addAll(oldGlue);
        }
    }

    private void printUsage() {
        System.out.println(USAGE);
    }

    public List<CucumberFeature> cucumberFeatures(ResourceLoader resourceLoader) {
        return CucumberFeature.load(resourceLoader, this.featurePaths, this.filters, System.out);
    }

    public Formatter formatter(ClassLoader classLoader) {
        return (Formatter)Proxy.newProxyInstance(classLoader, new Class[]{Formatter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Formatter formatter : RuntimeOptions.this.formatters) {
                    Utils.invoke(formatter, method, 0L, args);
                }
                return null;
            }
        });
    }

    public Reporter reporter(ClassLoader classLoader) {
        return (Reporter)Proxy.newProxyInstance(classLoader, new Class[]{Reporter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Formatter formatter : RuntimeOptions.this.formatters) {
                    if (!(formatter instanceof Reporter)) continue;
                    Utils.invoke(formatter, method, 0L, args);
                }
                return null;
            }
        });
    }

    private void setFormatterOptions() {
        for (Formatter formatter : this.formatters) {
            this.setMonochromeOnColorAwareFormatters(formatter);
            this.setStrictOnStrictAwareFormatters(formatter);
        }
    }

    private void setMonochromeOnColorAwareFormatters(Formatter formatter) {
        if (formatter instanceof ColorAware) {
            ColorAware colorAware = (ColorAware)formatter;
            colorAware.setMonochrome(this.monochrome);
        }
    }

    private void setStrictOnStrictAwareFormatters(Formatter formatter) {
        if (formatter instanceof StrictAware) {
            StrictAware strictAware = (StrictAware)formatter;
            strictAware.setStrict(this.strict);
        }
    }

    public List<String> getGlue() {
        return this.glue;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<String> getFeaturePaths() {
        return this.featurePaths;
    }

    public URL getDotCucumber() {
        return this.dotCucumber;
    }

    public List<Formatter> getFormatters() {
        return this.formatters;
    }

    public List<Object> getFilters() {
        return this.filters;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public SnippetType getSnippetType() {
        return this.snippetType;
    }
}

