/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RerunFormatter
implements Formatter,
Reporter {
    private final NiceAppendable out;
    private String featureLocation;
    private Step step;
    private Map<String, LinkedHashSet<Integer>> featureAndFailedLinesMapping = new HashMap<String, LinkedHashSet<Integer>>();

    public RerunFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    public void uri(String uri) {
        this.featureLocation = uri;
    }

    public void feature(Feature feature) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void step(Step step) {
        this.step = step;
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
        this.reportFailedSteps();
    }

    private void reportFailedSteps() {
        Set<Map.Entry<String, LinkedHashSet<Integer>>> entries = this.featureAndFailedLinesMapping.entrySet();
        boolean firstFeature = true;
        for (Map.Entry<String, LinkedHashSet<Integer>> entry : entries) {
            if (entry.getValue().size() <= 0) continue;
            if (!firstFeature) {
                this.out.append((CharSequence)" ");
            }
            this.out.append((CharSequence)entry.getKey());
            firstFeature = false;
            for (Integer line : entry.getValue()) {
                this.out.append((CharSequence)":").append((CharSequence)line.toString());
            }
        }
    }

    public void close() {
        this.out.close();
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        if (this.isTestFailed(result)) {
            this.recordTestFailed();
        }
    }

    private boolean isTestFailed(Result result) {
        String status = result.getStatus();
        return "failed".equals(status) || Result.UNDEFINED.getStatus().equals(status) || "pending".equals(status);
    }

    private void recordTestFailed() {
        LinkedHashSet<Integer> failedSteps = this.featureAndFailedLinesMapping.get(this.featureLocation);
        if (failedSteps == null) {
            failedSteps = new LinkedHashSet();
            this.featureAndFailedLinesMapping.put(this.featureLocation, failedSteps);
        }
        failedSteps.add(this.step.getLine());
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }
}

