/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.FeatureBuilder;
import cucumber.runtime.Runtime;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberBackground;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import cucumber.runtime.model.StepContainer;
import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CucumberFeature {
    private final String uri;
    private final Feature feature;
    private CucumberBackground cucumberBackground;
    private StepContainer currentStepContainer;
    private final List<CucumberTagStatement> cucumberTagStatements = new ArrayList<CucumberTagStatement>();
    private I18n i18n;
    private CucumberScenarioOutline currentScenarioOutline;

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths, List<Object> filters, PrintStream out) {
        List<CucumberFeature> cucumberFeatures = CucumberFeature.load(resourceLoader, featurePaths, filters);
        if (cucumberFeatures.isEmpty()) {
            if (featurePaths.isEmpty()) {
                out.println(String.format("Got no path to feature directory or feature file", new Object[0]));
            } else if (filters.isEmpty()) {
                out.println(String.format("No features found at %s", featurePaths));
            } else {
                out.println(String.format("None of the features at %s matched the filters: %s", featurePaths, filters));
            }
        }
        return cucumberFeatures;
    }

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths, List<Object> filters) {
        ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>();
        FeatureBuilder builder = new FeatureBuilder(cucumberFeatures);
        for (String featurePath : featurePaths) {
            Iterable<Resource> resources = resourceLoader.resources(featurePath, ".feature");
            for (Resource resource : resources) {
                builder.parse(resource, filters);
            }
        }
        Collections.sort(cucumberFeatures, new CucumberFeatureUriComparator());
        return cucumberFeatures;
    }

    public CucumberFeature(Feature feature, String uri) {
        this.feature = feature;
        this.uri = uri;
    }

    public void background(Background background) {
        this.cucumberBackground = new CucumberBackground(this, background);
        this.currentStepContainer = this.cucumberBackground;
    }

    public void scenario(Scenario scenario) {
        CucumberScenario cucumberTagStatement = new CucumberScenario(this, this.cucumberBackground, scenario);
        this.currentStepContainer = cucumberTagStatement;
        this.cucumberTagStatements.add(cucumberTagStatement);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        CucumberScenarioOutline cucumberScenarioOutline;
        this.currentScenarioOutline = cucumberScenarioOutline = new CucumberScenarioOutline(this, this.cucumberBackground, scenarioOutline);
        this.currentStepContainer = cucumberScenarioOutline;
        this.cucumberTagStatements.add(cucumberScenarioOutline);
    }

    public void examples(Examples examples) {
        this.currentScenarioOutline.examples(examples);
    }

    public void step(Step step) {
        this.currentStepContainer.step(step);
    }

    public Feature getGherkinFeature() {
        return this.feature;
    }

    public List<CucumberTagStatement> getFeatureElements() {
        return this.cucumberTagStatements;
    }

    public void setI18n(I18n i18n) {
        this.i18n = i18n;
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public String getUri() {
        return this.uri;
    }

    public void run(Formatter formatter, Reporter reporter, Runtime runtime) {
        formatter.uri(this.getUri());
        formatter.feature(this.getGherkinFeature());
        for (CucumberTagStatement cucumberTagStatement : this.getFeatureElements()) {
            cucumberTagStatement.run(formatter, reporter, runtime);
        }
        formatter.eof();
    }

    private static class CucumberFeatureUriComparator
    implements Comparator<CucumberFeature> {
        private CucumberFeatureUriComparator() {
        }

        @Override
        public int compare(CucumberFeature a, CucumberFeature b) {
            return a.getUri().compareTo(b.getUri());
        }
    }
}

