/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.dao.CloudInstanceDao;

/**
 * クラウドインスタンスの情報を保持するクラス。
 *
 */
public class CloudInstance implements Serializable, ICloudResource {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2744959762926787150L;

	private CloudInstanceDao dao;
	private String facilityName;
	private String platform;
	private String imageId;
	private String cloudTypeId;
	private InstanceStateKind state;
	private String flavor;
//	private long launchTime;
	private List<Tag> tags = new ArrayList<>();
	private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<>();
	
	private IResourceManagement.Instance instance;
	
	public CloudInstance() {
		super();
		this.dao = new CloudInstanceDao();
	}

	public CloudInstance(CloudInstanceDao dao, String cloudTypeId, String facilityName) {
		super();
		this.dao = dao;
		this.facilityName = facilityName;
		this.cloudTypeId = cloudTypeId;
	}

	public CloudInstance(CloudInstanceDao tableData, String cloudTypeId, IResourceManagement.Instance instance, String facilityName) {
		this(tableData, cloudTypeId, facilityName);

		this.instance = instance;
		
		this.platform = instance.getPlatform().label();
		this.imageId = instance.getImageId();
		this.state = InstanceStateKind.byLabel(instance.getState().name());
		this.flavor = instance.getFlavor();
		this.imageId = instance.getImageId();
//		this.launchTime = instance.getLaunchTime().getTime();
		for (Tag t: instance.getTags()) {
			Tag tag = new Tag(t.getKey(), t.getValue());
			this.tags.add(tag);
		}
		for (IResourceManagement.Instance.BlockDeviceMapping d: instance.getBlockDeviceMappings()) {
			BlockDeviceMapping device = new BlockDeviceMapping(
					d.getStorageId(), d.getDeviceName(), d.getStatus());
			this.blockDeviceMappings.add(device);
		}
	}

	/**
	 * インスタンスに紐づいたノードのファシリティ ID を取得する。
	 * 
	 * @return ファシリティ ID。
	 */
	public String getFacilityId() {
		return dao.getFacilityId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param facilityId
	 */
	public void setFacilityId(String facilityId) {
		throw new UnsupportedOperationException();
	}
	/**
	 * インスタンスに紐づいたノードのファシリティ名を取得する。
	 * 
	 * @return ファシリティ名。
	 */
	public String getFacilityName() {
		return facilityName;
	}
	/**
	 * 使用禁止。
	 * 
	 * @return
	 */
	public void setFacilityName(String facilityName) {
		throw new UnsupportedOperationException();
	}
	/**
	 * インスタンス ＩＤ を取得する。
	 * 
	 * @return インスタンス ＩＤ。
	 */
	public String getInstanceId() {
		return dao.getInstanceId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param instanceId
	 */
	public void setInstanceId(String instanceId) {
		throw new UnsupportedOperationException();
	}

	/**
	 * インスタンスにインストールされている OS の名前を取得する。 
	 * 
	 * @return インスタンスにインストールされている OS の名前
	 */
	public String getPlatform() {
		return platform;
	}
	/**
	 * 使用禁止。
	 * 
	 * @param platform
	 */
	public void setPlatform(String platform) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンスが所属するアカウントリソース ID を取得する。
	 * 
	 * @return アカウントリソース ID
	 */
	public String getAccountResourceId() {
		return dao.getAccountResourceId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param accountResourceId
	 */
	public void setAccountResourceId(String accountResourceId) {
		throw new UnsupportedOperationException();
	}

	/**
	 * インスタンスが所属するリージョンを取得する。
	 * 
	 * @return インスタンスが所属するリージョン
	 */
	public String getRegion() {
		return dao.getRegion();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param region
	 */
	public void setRegion(String region) {
		throw new UnsupportedOperationException();
	}

	/**
	 * インスタンスが所属するゾーンを取得する。
	 * 
	 * @return インスタンスが所属するゾーン
	 */
	public String getZone() {
		return dao.getZone();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param zone
	 */
	public void setZone(String zone) {
		throw new UnsupportedOperationException();
	}

	/**
	 * インスタンスのテンプレートとして使用したイメージ ID を取得する。
	 * 
	 * @return インスタンスのテンプレートとして使用したイメージ ID。
	 */
	public String getImageId() {
		return imageId;
	}
	/**
	 * 使用禁止。
	 * 
	 * @param imageId
	 */
	public void setImageId(String imageId) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンスに紐づいたテンプレート ID を取得する。
	 * 
	 * @return インスタンスに紐づいたテンプレート ID。
	 */
	public String getTemplateId() {
		return dao.getTemplateId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param templateId
	 */
	public void setTemplateId(String templateId) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンスの状態を取得する。
	 * 
	 * @return インスタンスの状態。
	 */
	public InstanceStateKind getState() {
		return state;
	}
	/**
	 * 使用禁止。
	 * 
	 * @param state
	 */
	public void setState(InstanceStateKind state) {
		throw new UnsupportedOperationException();
	}

	/**
	 * クラウド側のインスタンスの登録状態を取得する。
	 * 
	 * @return クラウド側のインスタンスの登録状態。
	 */
	public InstanceRegistStateType getRegistState() {
		if (dao.getRegistStatus() == null) {
			return null;
		}
		return InstanceRegistStateType.valueOf(dao.getRegistStatus().name());
	}
	/**
	 * 使用禁止。
	 * 
	 * @param registState
	 */
	public void setRegistState(InstanceRegistStateType registState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンスの種別を取得する。
	 * 
	 * @return インスタンス種別。
	 */
	public String getFlavor() {
		return flavor;
	}
	/**
	 * 使用禁止。
	 * 
	 * @param flavor
	 */
	public void setFlavor(String flavor) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンスに紐づいたタグの一覧を取得する。
	 * 
	 * @return タグの一覧。
	 */
	public List<Tag> getTags() {
		return tags;
	}
	/**
	 * 使用禁止。
	 * 
	 * @param tags
	 */
	public void setTags(List<Tag> tags) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンス名を取得する。
	 * 
	 * @return インスタンス名。
	 */
	public String getInstanceName() {
		return dao.getInstanceName();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param instanceName
	 */
	public void setInstanceName(String instanceName) {
		throw new UnsupportedOperationException();
	}

	/**
	 * インスタンスをクラウド管理へ登録したクラウドユーザーを取得します。
	 * 
	 * @return インスタンスをクラウド管理へ登録したクラウドユーザー。
	 */
	public String getCloudUserId() {
		return dao.getCloudUserId();
	}
	/**
	 * 使用禁止。
	 * 
	 * @param cloudUserId
	 */
	public void setCloudUserId(String cloudUserId) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * インスタンスにアタッチされているディスクの一覧を取得する。
	 * 
	 * @return インスタンスにアタッチされているディスクの一覧
	 */
	public List<BlockDeviceMapping> getBlockDeviceMappings() {
		return blockDeviceMappings;
	}
	
	/**
	 * 未使用。
	 * 
	 * @param blockDeviceMappings
	 */
	public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
		throw new UnsupportedOperationException();
	}

	/**
	 * この情報を登録した日時を取得する。
	 * 
	 * @return この情報を登録した日時。
	 */
	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}
	/**
	 * 未使用。
	 * 
	 * @param regDate
	 */
	public void setRegDate(Long regDate) {
		throw new UnsupportedOperationException();
	}

	/**
	 * この情報を更新した日時を取得する。
	 * 
	 * @return この情報を更新した日時。
	 */
	public Long getUpdateDate() {
		return dao.getUpdateDate() != null ? dao.getUpdateDate().getTime(): null;
	}
	/**
	 * 未使用。
	 * 
	 * @param updateDate
	 */
	public void setUpdateDate(Long updateDate) {
		throw new UnsupportedOperationException();
	}

	/**
	 * この情報を登録した Hinemos ユーザーを取得する。
	 * 
	 * @return この情報を登録した Hinemos ユーザー。
	 */
	public String getRegUser() {
		return dao.getRegUser();
	}
	/**
	 * 未使用。
	 * 
	 * @param regUser
	 */
	public void setRegUser(String regUser) {
		throw new UnsupportedOperationException();
	}

	/**
	 * この情報を更新した Hinemos ユーザーを取得する。
	 * 
	 * @return この情報を更新した Hinemos ユーザー。
	 */
	public String getUpdateUser() {
		return dao.getUpdateUser();
	}
	/**
	 * 未使用。
	 * 
	 * @param updateUser
	 */
	public void setUpdateUser(String updateUser) {
		throw new UnsupportedOperationException();
	}

	/**
	 * この情報のクラウドタイプを取得する。
	 * 
	 * @return クラウドタイプ。
	 */
	public String getCloudTypeId() {
		return cloudTypeId;
	}
	/**
	 * 未使用。
	 * 
	 * @param cloudTypeId
	 */
	public void setCloudTypeId(String cloudTypeId) {
		throw new UnsupportedOperationException();
	}

	@XmlTransient
	public IResourceManagement.Instance getResource() {
		return instance;
	}
}
