#!/bin/sh

##
##
## Windows Azure を利用するためのキー作成ツールです
##            microsoft-azure-api-0.5.0.jar
## 
## 利用方法：
##            sh ./makeazurekey.sh [keyname]
##
## パラメータ: 
##            keyname : キー名称 Azureポータルにアクセスする名前
##
## 出力ファイル:
##            [keyname].pfx : microsoft-azure-apiで利用する証明書（PKCS12形式)
##            [keyname].b64 : hinemosのクライアントで利用するシークレットキーの内容
##            [keyname].cer : Azureポータルサイトにアップロードするファイル証明書
##            [keyname].crt : curlで利用するときのファイル証明書
##            [keyname].pem : curlで利用するときのファイル証明書
##
##
## 必須コマンド:
##            sh, keytool, base64, openssl
##
##

KEYNAME=hinemos
if [ x"$1" != x"" ] 
then
	KEYNAME=$1
fi

KEYPASS=changeit
if [ x"$2" != x"" ] 
then
	KEYPASS=$2
fi

if [ -f ${KEYNAME}.pfx ]
then
        while [ 1 ]
        do
                read -p "`echo "${KEYNAME}.pfx ファイルが存在します。上書きしてもよろしいでしょうか(y/n)"` : " INPUT
                INPUT=${INPUT:-N}
                case ${INPUT} in
                        y|Y)
                                break
                                ;;
                        n|N)
				echo "Usage: $0 [keyname]"
				echo "default: keyname=hinemos"
                                echo "終了します"
                                exit 255
                                ;;
                        *)
                                echo "入力が不正です。もう一度入力してください"
                                ;;
                esac
        done
fi

rm -f ${KEYNAME}.pfx ${KEYNAME}.cer ${KEYNAME}.b64 ${KEYNAME}.crt ${KEYNAME}.pem
keytool -genkeypair -alias ${KEYNAME} -keystore ${KEYNAME}.pfx -dname "CN=${KEYNAME}" -storetype pkcs12 -storepass ${KEYPASS} -validity 3650 -keyalg RSA -keysize 2048 
if [ $? -ne 0 ]
then
	echo "エラーが発生しました"
	exit 255
fi
keytool -export     -alias ${KEYNAME} -keystore ${KEYNAME}.pfx -file ${KEYNAME}.cer   -storetype pkcs12 -storepass ${KEYPASS} >/dev/null 2>/dev/null
if [ $? -ne 0 ]
then
	echo "エラーが発生しました"
	exit 255
fi
base64 ${KEYNAME}.pfx > ${KEYNAME}.b64
if [ $? -ne 0 ]
then
	echo "エラーが発生しました"
	exit 255
fi

openssl pkcs12 -in ${KEYNAME}.pfx -passin pass:${KEYPASS} -nocerts -nodes  -out ${KEYNAME}.pem 2>/dev/null >/dev/null
if [ $? -ne 0 ]
then
	echo "エラーが発生しました"
	exit 255
fi
openssl pkcs12 -in ${KEYNAME}.pfx -passin pass:${KEYPASS} -clcerts -nokeys -out ${KEYNAME}.crt 2>/dev/null >/dev/null
if [ $? -ne 0 ]
then
	echo "エラーが発生しました"
	exit 255
fi

echo ""
echo ""
echo "${KEYNAME}.pfx ${KEYNAME}.cer ${KEYNAME}.b64 ファイルを作成しました"
echo ""
echo ""
sleep 2
echo "${KEYNAME}.cer をAzureポータルにアップロードしてください"
echo ""
echo ""
sleep 2
echo "Base64データをHinemosクライアントのシークレットキーに入力してください"
read -p "`echo "次の行からBase64のデータを表示します。Enterを押してください"` : " INPUT
echo ""
echo ""

cat ${KEYNAME}.b64

echo ""
echo ""
echo ""
echo "終了しました"
echo "HinemosとAzureポータルに設定後、ファイルを削除してください"
echo "削除するファイル ${KEYNAME}.pfx ${KEYNAME}.cer ${KEYNAME}.b64"
echo ""

