package com.clustercontrol.cloud.azure.bean;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.IResourceManagement.Instance;

public class AzurePendingInstances {
	
	private class AzurePendingInstanceInfo{
		Instance azureInstance = new Instance();
		String regionName = "";
		String accessKey = "";
		
		public String getRegionName(){
			return this.regionName;
		}
		
		public void setRegionName(String regionName){
			this.regionName = regionName; 
		}
		
		public String getAccessKey(){
			return this.accessKey;
		}
		
		public void setAccessKey(String accessKey){
			this.accessKey = accessKey;
		}
		
		public Instance getAzureInstance(){
			return this.azureInstance;
		}
		
		public void setAzureInstance(Instance azureInstance){
			this.azureInstance = azureInstance; 
		}
		
	}

	private static AzurePendingInstances instance;
	private List<AzurePendingInstanceInfo> azureInstances = new ArrayList<AzurePendingInstanceInfo>();
	
	private AzurePendingInstances(){
		instance = null;
	}
	
	public static AzurePendingInstances getInstance(){
		if(instance==null){
			instance = new AzurePendingInstances();
		}
		return instance;
	}
	
	public void addAzureInstance(Instance azureInstance, String regionName, String accessKey){
		AzurePendingInstanceInfo azurePendingInstanceInfo = new AzurePendingInstanceInfo();
		azurePendingInstanceInfo.setAzureInstance(azureInstance);
		azurePendingInstanceInfo.setRegionName(regionName);
		azurePendingInstanceInfo.setAccessKey(accessKey);
		azureInstances.add(azurePendingInstanceInfo);
	}
	
	public Instance getAzureInstance(String instanceID, String regionName, String accessKey){
		for(AzurePendingInstanceInfo azureInstance:azureInstances){
			if(azureInstance.getRegionName().equals(regionName)&&
					azureInstance.getAccessKey().equals(accessKey) &&
					azureInstance.getAzureInstance().getInstanceId().equals(instanceID)){
				return azureInstance.getAzureInstance();
			}
		}
		return null;
	}
	
	public void removeAzureInstance(String instanceID, String regionName, String accessKey){
		for(AzurePendingInstanceInfo azureInstance:azureInstances){
			if(azureInstance.getAzureInstance().getInstanceId().equals(instanceID)&&
					azureInstance.getAccessKey().equals(accessKey)&&
					azureInstance.getRegionName().equals(regionName)){
				azureInstances.remove(azureInstance);
				return;
			}
		}
	}
	
	public List<Instance> getAzureInstances(String regionName, String accessKey){
		List<Instance> instances = new ArrayList<Instance>();
		for(AzurePendingInstanceInfo azureInstance:azureInstances){
			if(azureInstance.getAccessKey().equals(accessKey)&&
					azureInstance.getRegionName().equals(regionName)){
				instances.add(azureInstance.getAzureInstance());
			}
		}
		return instances;
	}
	
	public boolean isExist(String instanceID, String regionName, String accessKey){
		boolean isExist=false;
		for(AzurePendingInstanceInfo azureInstance:azureInstances){
			if(azureInstance.getAzureInstance().getInstanceId().equals(instanceID)&&
					azureInstance.getAccessKey().equals(accessKey)&&
					azureInstance.getRegionName().equals(regionName))
			isExist = true;
		}
		return isExist;
	}
}
