package com.clustercontrol.cloud.azure.factory;

import java.util.ArrayList;

public class AzureAsyncExecution  {

	private static AzureAsyncExecution singleton = null;
	private ArrayList<AzureAsyncOperations> que = null;
	private ArrayList<AzureAsyncOperations> delay = null;
	
	public static AzureAsyncExecution getSingleton() {
		if (singleton == null) {
			synchronized (AzureAsyncExecution.class) {
				if (singleton == null) {
		            singleton = new AzureAsyncExecution();
		            singleton.que = new ArrayList<>();
		            singleton.delay = new ArrayList<>();
				}
			}
		}
		return singleton;
	}
	
	public void put(AzureAsyncOperations add){
		synchronized(que){
			que.add(add);
			que.notify();
		}
	}
	
	public AzureAsyncOperations get(int second){
		synchronized(que){
			if(que.size()==0){
				try {
					que.wait((second/2)+1000);
				} catch (InterruptedException e) {}
			}
			if(que.size()==0)
				return null;
			return que.remove(0);
		}
	}
	
	public void merge(AzureAsyncOperations merge){
		synchronized(delay){
			for(AzureAsyncOperations async:delay){
				if(async.getKey().equals(merge.getKey())){
					async.addParams(merge.getParams());
					return;
				}
			}
			delay.add(merge);
		}
	}
	
	public boolean getTimeout(int second){
		synchronized(delay){
			if(delay.size()==0)
				return false;
			for(AzureAsyncOperations async:delay){
				if(async.isTimeOut(second)){
					delay.remove(async);
					put(async);
					return true;
				}
			}
		}
		return false;
	}
}
