package com.clustercontrol.cloud.azure.factory;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;

public class AzureAsyncOperationStatus extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private ComputeManagementClient computeManagementClient = null;
	private String requestId = null; 
	private String message = null;
	
	public AzureAsyncOperationStatus(ComputeManagementClient computeManagementClient, String requestId, String message) {
		this.computeManagementClient = computeManagementClient;
		this.requestId = requestId;
		this.message = message;
	}
	
	@Override
	public void execute() {
		logger.debug("AzureAsyncOperationStatus:execute() start" + " " +  message);
    	OperationStatusResponse operationStatusResponse = null;
		try {
			for (;;) {
				logger.debug("computeManagementClient.getOperationStatus(" + requestId + ") " + message);			
				operationStatusResponse = computeManagementClient.getOperationStatus(requestId);
				if (operationStatusResponse.getStatus() == OperationStatus.InProgress) {
					logger.debug("AzureAsyncOperationStatus:execute() operationStatusResponse:InProgress " + message);			
					Thread.sleep(1000);
				}
				else if (operationStatusResponse.getStatus() == OperationStatus.Succeeded) {
					logger.info("AzureAsyncOperationStatus:execute() operationStatusResponse:Succeeded " + message);			
					break;
				}
				else if (operationStatusResponse.getStatus() == OperationStatus.Failed) {
					logger.error("AzureAsyncOperationStatus:execute() operationStatusResponse:Failed " + message);			
					break;
				}
				else {
					logger.error("AzureAsyncOperationStatus:execute() operationStatusResponse:?????(unknown) " + message);			
					break;
				}
			}
		} catch (InterruptedException e) {
			logger.error("AzureAsyncOperationStatus:execute() InterruptedException:" + e.getMessage() + " " +  message);			
		} catch (IOException e) {
			logger.error("AzureAsyncOperationStatus:execute() IOException:" + e.getMessage() + " " +  message);			
		} catch (ServiceException e) {
			logger.error("AzureAsyncOperationStatus:execute() ServiceException:" + e.getMessage() + " " +  message);			
		} catch (ParserConfigurationException e) {
			logger.error("AzureAsyncOperationStatus:execute() ParserConfigurationException:" + e.getMessage() + " " +  message);			
		} catch (SAXException e) {
			logger.error("AzureAsyncOperationStatus:execute() SAXException:" + e.getMessage() + " " +  message);			
		}
		finally {
			logger.debug("AzureAsyncOperationStatus:execute() end" + " " +  message);			
		}
	}
}
