package com.clustercontrol.cloud.azure.factory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.util.HinemosUtil;

public class AzureAsyncOperations {
	private boolean bAsyncMode = false;
	private String key = "";
	private ArrayList<String> params = new ArrayList<>();
	private Date updateTime = new Date();
	private Calendar cal = null;

	public void setAsyncMode() {
		bAsyncMode = true;
	}
	
	public boolean isAsync() {
		return bAsyncMode;
	}
	
	public void setKey(String key){
		this.key = key;
	}
	
	public String getKey(){
		return this.key;
	}
	
	public void addParams(String param){
		this.params.add(param);
		cal=Calendar.getInstance();
		this.updateTime = cal.getTime();
	}
	
	public void addParams(List<String> param){
		this.params.addAll(param);
		cal=Calendar.getInstance();
		this.updateTime = cal.getTime();
	}
	
	public ArrayList<String> getParams(){
		return this.params;
	}
	
	public boolean isTimeOut(int second){
		cal=Calendar.getInstance();
		cal.add(Calendar.SECOND,second * -1);
		return cal.getTime().after(updateTime);
	}
	
	public void execute() throws CloudManagerFault {	
		Logger logger = Logger.getLogger(this.getClass());
		logger.info("AzureAsyncOperations:execute(nop)");    
	}
	
	public void putLog(String msgID,String message,String message_detail){
		/*AplLogger cloud = new AplLogger("CLOUD", "Azure");
		cloud.put("SYS", msgID, null, message);*/
		if(isAsync()){
			HinemosUtil.notifyInternalMessage(
					HinemosUtil.Priority.WARNING,
					"CLOUD",
					"Azure",
					"",
					"CLOUD",
					msgID,
					message,
					message_detail);
		}
	}
	
}
