package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;

public class AzureAsyncThread extends Thread {

	private AzureAsyncExecution azureAsyncExecution = null;
	private boolean isStop = false;
	
	public void run(){
		this.setName(getClass().getSimpleName() + "-" + this.getName());
		azureAsyncExecution = AzureAsyncExecution.getSingleton();
		AzureAsyncOperations azureAsyncOperations = null;
		int timeout = Integer.valueOf(AzureOptionPropertyConstants.azure_async_delay_time.value());
		while(!isStop){
			while(azureAsyncExecution.getTimeout(timeout)){
			}
			
			azureAsyncOperations = azureAsyncExecution.get(timeout);
			if (azureAsyncOperations != null) {
				if (!isStop){
					try {
						azureAsyncOperations.setAsyncMode();
						azureAsyncOperations.execute();
					} catch (CloudManagerFault e) {
					} catch (Exception e) {
					}
				}
			}
		}
	}
	
	public void terminate(){
		isStop=true;
		if (azureAsyncExecution != null) {
			azureAsyncExecution.put(new AzureAsyncOperations());
		}
	}
}
