package com.clustercontrol.cloud.azure.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;

import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.VirtualMachineOSImageOperations;

public class AzureDeleteInstanceBackup extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private String instanceBackupId = null;
	private Configuration config = null;
	
	public AzureDeleteInstanceBackup(Configuration config, String instanceBackupId) {
		this.config = config;
		this.instanceBackupId = instanceBackupId;
	}
	
	public void execute() throws CloudManagerFault {
		
		try{
	    	logger.info("AzureDeleteInstanceBackup start: " + instanceBackupId );

			ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);
			VirtualMachineOSImageOperations virtualMachineOSImageOperations = computeManagementClient.getVirtualMachineOSImagesOperations();
			
	 		logger.info("VirtualMachineOSImageOperations.delete(" + instanceBackupId + ")");
			OperationResponse operationResponse = virtualMachineOSImageOperations.delete(instanceBackupId, true);
	 		logger.info("RequestId:" + operationResponse.getRequestId());
	 		
	        for(;;){
        		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
     			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
     				logger.info("deleting " + getClass().getSimpleName() + "...");
     				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
     					logger.info("successful in delete " + getClass().getSimpleName() + "...");
     				}else{
     					logger.error("failed in delete " + operationStatusResponse.getError());
	 					putLog("DeleteInstanceBackup","DeleteInstanceBackup was failed",operationStatusResponse.getError().getMessage());
	 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
     				}
     				break;
     			}
        	}
		}catch(ServiceException e){
			logger.error("AzureDeleteInstanceBackup: (" + e.getErrorCode() +") "+ e.getMessage());
			putLog("DeleteInstanceBackup","DeleteInstanceBackup was failed",e.getStackTrace().toString());
			throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		}catch(Exception e){
			logger.error("AzureDeleteInstanceBackup: " + e.getMessage());
			putLog("DeleteInstanceBackup","DeleteInstanceBackup was failed",e.getStackTrace().toString());
			throw new CloudManagerFault(e.getMessage(), e);
	    } finally {
	    	logger.info("AzureDeleteInstanceBackup end: " + instanceBackupId );
	    }		
	}
}
