package com.clustercontrol.cloud.azure.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse.HostedService;

public class AzureDetachStorage extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private String instanceId = null;
	private String storageId = null;
	private Configuration config = null;
	
	public AzureDetachStorage(Configuration config, String instanceId, String storageId) {
		this.config = config;
		this.instanceId = instanceId;
		this.storageId = storageId;
	}
	
	public void execute() throws CloudManagerFault {

	 	String deploymentName = "";
		String cloudServiceName = "";
		String roleName = "";
		int logicalUnitNumber = 0;
		
		try{
	    	logger.info("AzureDetachStorage start: " + instanceId + ", " + storageId );
			
			ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);

			VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();
			DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
			HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();

	    	HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
	 		for (HostedService hostService: hostedServiceListResponse.getHostedServices()) {
	 			for (DeploymentSlot slot:AzureUtil.getDeploymentSlots()) {
	 				DeploymentGetResponse deploymentGetResponse = null;
		 			try {
			 			deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(),slot);
		 			}
		 			catch (ServiceException e) {
		 				if (e.getErrorCode().equals("ResourceNotFound"))
		 					continue;
		 		   		throw new CloudManagerFault(e.getMessage(), e);
		 			}
		 			deploymentGetResponse.getRoles();
		 			for (Role role:deploymentGetResponse.getRoles()) {
		 				if(role.getRoleName().equals(instanceId)){
		 					cloudServiceName = hostService.getServiceName();
		 					deploymentName = deploymentGetResponse.getName();
 							roleName = role.getRoleName();
		 					for(DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()){
		 						if(dvhd.getName().equals(storageId)){
		 							logicalUnitNumber = (dvhd.getLogicalUnitNumber() == null ? 0 : dvhd.getLogicalUnitNumber().intValue());
		 							
		 					        logger.info("virtualMachineDiskOperations.beginDeletingDataDisk(" + cloudServiceName +","+ deploymentName +","+ roleName +","+ logicalUnitNumber +")");
		 							OperationResponse operationResponse = virtualMachineDiskOperations.beginDeletingDataDisk(cloudServiceName, deploymentName, roleName, logicalUnitNumber, false);
		 					        logger.info("RequestId:" + operationResponse.getRequestId());
		 					        
		 					        for(;;){
		 				        		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
		 				     			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
		 				     				logger.info("detaching " + getClass().getSimpleName() + "...");
		 				     				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
		 				     					logger.info("successful in detaching " + getClass().getSimpleName() + "...");
		 				     				}else{
		 				     					logger.error("failed in detaching " + operationStatusResponse.getError());
		 					 					putLog("DetacheStorage","DetacheStorage was failed",operationStatusResponse.getError().getMessage());
							 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
		 				     				}
		 				     				break;
		 				     			}
		 				        	}
				 			 		return;
		 						}
			 				}
		 				}
		 			}
	 			}
	 		}
		}catch(ServiceException e){
			putLog("DetacheStorage","DetacheStorage was failed",e.getMessage());
    		throw new CloudManagerFault(e.getMessage(), e);
    	}catch(Exception e){
    		putLog("DetacheStorage","DetacheStorage was failed",e.getMessage());
    		throw new CloudManagerFault(e.getMessage(), e);
    	} finally {
	    	logger.info("AzureDetachStorage end: " + instanceId + ", " + storageId );
    	}
	}
}
