package com.clustercontrol.cloud.azure.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.models.PostShutdownAction;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineShutdownRolesParameters;

public class AzureStopInstance extends AzureAsyncOperations{
	private	Logger logger = Logger.getLogger(this.getClass());
	private Configuration config = null;
	private String cloudServiceName = null;
	private String deploymentName = null;
	
	public AzureStopInstance(Configuration config,
							 String cloudServiceName,
							 String deploymentName){
		this.config = config;
		this.cloudServiceName = cloudServiceName;
		this.deploymentName = deploymentName;
	}
	
	public void execute() throws CloudManagerFault {
		OperationResponse operationResponse = new OperationResponse();
		ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);
		VirtualMachineOperations virtualMachineOperations = computeManagementClient.getVirtualMachinesOperations();
		
		try {
			VirtualMachineShutdownRolesParameters shutdownPrm = new VirtualMachineShutdownRolesParameters();
			shutdownPrm.setRoles(this.getParams());
			shutdownPrm.setPostShutdownAction(PostShutdownAction.StoppedDeallocated);
			
			logger.info("VirtualMachineOperations.beginStopingRoles(" + cloudServiceName +","+ deploymentName +")");
			operationResponse = virtualMachineOperations.beginShuttingDownRoles(cloudServiceName, deploymentName, shutdownPrm);
	        logger.info("RequestId:" + operationResponse.getRequestId());
			
	        for(;;){
        		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
     			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
     				logger.info("stoping " + getClass().getSimpleName() + "...");
     				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
     					logger.info("successful in stoping " + getClass().getSimpleName() + "...");
     				}else{
     					logger.error("failed in stoping " + operationStatusResponse.getError());
	 					putLog("stopInstance","stopInstance was failed",operationStatusResponse.getError().getMessage());
	 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
     				}
     				return;
     			}
        	}
	        
		} catch (Exception e) {
			putLog("StopInstance","StopInstance was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
		} finally{
			logger.info("Finish AzureStopInstance:" + this.getParams());
		}
	}
}
