package com.clustercontrol.xcloud.aws.ui.handlers;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AWSOptionEndpoint;
import com.clustercontrol.ws.xcloud.ModifyInstanceAttribute;
import com.clustercontrol.xcloud.aws.common.AWSConstants;
import com.clustercontrol.xcloud.aws.ui.dialogs.AWSResourceProvider;
import com.clustercontrol.xcloud.aws.ui.dialogs.ModifyConfigDialog;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IInstance;


public class ModifyInstanceConfigHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IInstance instance = (IInstance)selection.getFirstElement();
		
		ModifyConfigDialog dialog = new ModifyConfigDialog(HandlerUtil.getActiveShell(event), instance.getExtendedProperty(AWSConstants.EPROP_Instance_InstanceType), new AWSResourceProvider(instance.getLocation()));
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmModifyComputeNode, instance.getName(), instance.getId()))) {
				try {
					AWSOptionEndpoint endpoint = instance.getLocation().getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(AWSOptionEndpoint.class);
					
					ModifyInstanceAttribute.Attributes attributes = new ModifyInstanceAttribute.Attributes();
					ModifyInstanceAttribute.Attributes.Entry entry = new ModifyInstanceAttribute.Attributes.Entry();
					
					// instanceType は、AWS Sdk で定義されている文字列！！
					entry.setKey("instanceType");
					entry.setValue(dialog.getSelectedInstanceType());
					attributes.getEntry().add(entry);
					
					endpoint.modifyInstanceAttribute(instance.getLocation().getCloudScope().getId(), instance.getLocation().getId(), instance.getId(), attributes);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						msgFinishModifyComputeNode);
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							instance.getLocation().updateLocation();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}