/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.aws.ui.dialogs;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_Vpc;

import java.text.MessageFormat;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.ws.xcloud.ExtendedProperty;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.ws.xcloud.NetworkInterface;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.INetwork;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.util.ControlUtil;

public class DetachSubnetDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	protected Instance targetInstance;
	protected NetworkInterface targetNetworkInterface;
	protected INetwork network;
	protected Combo cmbInstances;
	private Combo cmbNic;
	
	AWSResourceProvider provider;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public DetachSubnetDialog(Shell parentShell, INetwork network) {
		super(parentShell);
		this.network = network;
		this.provider = new AWSResourceProvider(network.getLocation());
	}

	public Instance getInstance(){
		return targetInstance;
	}

	public NetworkInterface getNetworkInterface(){
		return targetNetworkInterface;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblNewLabel = new Label(container, SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel.setText(strManager + strSeparator);
		
		Label lblNewLabel_4 = new Label(container, SWT.BORDER);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		lblNewLabel_4.setText(network.getLocation().getCloudScope().getCloudScopes().getHinemosManager().getManagerName());
		
		Label lblNewLabel_1 = new Label(container, SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_1.setText(strCloudScope + strSeparator);
		
		Label lblNewLabel_5 = new Label(container, SWT.BORDER);
		lblNewLabel_5.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_5.setText(String.format("%s (%s)", network.getLocation().getCloudScope().getName(), network.getLocation().getCloudScope().getId()));
		
		Label lblVolumeType = new Label(container, SWT.NONE);
		lblVolumeType.setAlignment(SWT.RIGHT);
		lblVolumeType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblVolumeType.setText(strNetwork + strSeparator);
		
		Label lblNewLabel_2 = new Label(container, SWT.BORDER);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_2.setText(String.format("%s (%s)", network.getName(), network.getId()));
		
		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setAlignment(SWT.RIGHT);
		lblInstance.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblInstance.setText(strCompute + strSeparator);
		
		cmbInstances = new Combo(container, SWT.READ_ONLY);
		cmbInstances.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				cmbNic.removeAll();
				
				Instance instance = (Instance)cmbInstances.getData(cmbInstances.getText());
				if (instance != null) {
					List<NetworkInterface> nics = provider.getNetworkInterfaces(network.getId(), false);
					for (NetworkInterface nic: nics) {
						if (nic.getAttachment() == null || !instance.getId().equals(nic.getAttachment().getInstanceId()))
							continue;
						String nicItem = String.format("%s (%s)", nic.getName() == null ? "": nic.getName(), nic.getId());
						cmbNic.add(nicItem);
						cmbNic.setData(nicItem, nic);
					}
				}
			}
		});
		cmbInstances.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		cmbInstances.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		
		
		Label lblSnapshot = new Label(container, SWT.NONE);
		lblSnapshot.setAlignment(SWT.RIGHT);
		lblSnapshot.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblSnapshot.setText(strNetworkInterface + strSeparator);
		
		cmbNic = new Combo(container, SWT.READ_ONLY);
		cmbNic.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cmbNic.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		
		String vpdId = network.getExtendedProperty(EPROP_Vpc);
		List<Instance> instances = provider.getInstances();
		List<NetworkInterface> nics = provider.getNetworkInterfaces(network.getId(), false);
		for (Instance instance: instances) {
			for (ExtendedProperty prop: instance.getExtendedProperties()) {
				if (!prop.getName().equals(EPROP_Vpc))
					continue;
				if (prop.getValue() != null && prop.getValue().equals(vpdId)) {
					for (NetworkInterface nic: nics) {
						if (nic.getAttachment() == null || !instance.getId().equals(nic.getAttachment().getInstanceId()))
							continue;
						
						String instanceItem = String.format("%s (%s)", instance.getName() == null ? "": instance.getName(), instance.getId());
						cmbInstances.add(instanceItem);
						cmbInstances.setData(instanceItem, instance);
						break;
					}
				}
				break;
			}
		}
		
		if (targetInstance != null) {
			for (String item: cmbInstances.getItems()) {
				Instance instance = (Instance)cmbInstances.getData(item);
				if (instance.getId().equals(targetInstance.getId())) {
					cmbInstances.setText(item);
					break;
				}
			}

			for (NetworkInterface nic: provider.getNetworkInterfaces(network.getId(), false)) {
				if (nic.getAttachment() == null || !targetInstance.getId().equals(nic.getAttachment().getInstanceId()))
					continue;
				String nicItem = String.format("%s (%s, %s)", nic.getName() == null ? "": nic.getName(), nic.getId(), nic.getPrivateIpAddress());
				cmbNic.add(nicItem);
				cmbNic.setData(nicItem, nic);
			}
		}
		
		if (targetNetworkInterface != null) {
			for (String item: cmbNic.getItems()) {
				NetworkInterface nic = (NetworkInterface)cmbNic.getData(item);
				if (nic.getId().equals(targetNetworkInterface.getId())) {
					cmbNic.setText(item);
					break;
				}
			}
		}
		
		ControlUtil.setRequired(new Control[]{cmbInstances, cmbNic});
		
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				checkFinished();
			}
		});

		return area;
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(657, 265);
	}

	@Override
	protected void okPressed() {
		targetInstance = (Instance)cmbInstances.getData(cmbInstances.getText());
		targetNetworkInterface = (NetworkInterface)cmbNic.getData(cmbNic.getText());
		
		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(MessageFormat.format(dlgNetworkDetach, strAws));
	}
	
	protected void checkFinished() {
		Button okButton = getButton(IDialogConstants.OK_ID);
		if (okButton == null)
			return;
			
		if (cmbInstances != null && !cmbInstances.getText().isEmpty() &&
			cmbNic != null && !cmbNic.getText().isEmpty()
			) {
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		} else {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
}