package com.clustercontrol.xcloud.aws.ui.dialogs;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_AvailabilityZone;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_Subnet;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.ws.xcloud.ExtendedProperty;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.util.CollectionComparator;

public class InstanceSelector implements CloudStringConstants, AWSStringConstants {
	protected CheckboxTableViewer tableViewer;
	protected List<Instance> availableInstances = new ArrayList<>();
	protected List<String> selected = new ArrayList<>();
	
	protected final int[] defaultColumnSizes = {120, 120, 120, 120};
	protected int[] actualColumnSizes;
	
	public InstanceSelector(CheckboxTableViewer tableViewer, int[] columnSizes, List<Instance> availableInstances, List<String> selected) {
		this.tableViewer = tableViewer;
		this.availableInstances.addAll(availableInstances);
		this.actualColumnSizes = getColumnSizes(columnSizes);
		this.selected.addAll(selected);
		initTableViewer();
	}
	
	protected void initTableViewer() {
		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tblclmnNewColumn.setWidth(actualColumnSizes[0]);
		tblclmnNewColumn.setText(strComputeId);
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {
				Instance instance = (Instance)element;
				return String.format("%s", instance.getId());
			}
		});
		
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tblclmnNewColumn_1.setWidth(actualColumnSizes[1]);
		tblclmnNewColumn_1.setText(strName);
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {
				Instance instance = (Instance)element;
				return instance .getName() == null || instance .getName().isEmpty() ? "": instance .getName();
			}
		});
		
		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tblclmnNewColumn_2.setWidth(actualColumnSizes[3]);
		tblclmnNewColumn_2.setText(strAvailabilityZone);
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {
				Instance instance = (Instance)element;
				String availabilityZone = null;
				for (ExtendedProperty prop: instance.getExtendedProperties()) {
					if (prop.getName().equals(EPROP_AvailabilityZone)) {
						availabilityZone = prop.getValue();
						break;
					}
				}
				return availabilityZone == null || availabilityZone.isEmpty() ? "": availabilityZone;
			}
		});

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tblclmnNewColumn_3.setWidth(actualColumnSizes[2]);
		tblclmnNewColumn_3.setText(strSubnetId);
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider() {
			@Override public String getText(Object element) {
				Instance instance = (Instance)element;
				String vpcId = null;
				for (ExtendedProperty prop: instance.getExtendedProperties()) {
					if (prop.getName().equals(EPROP_Subnet)) {
						vpcId = prop.getValue();
						break;
					}
				}
				return vpcId == null || vpcId.isEmpty() ? "": vpcId;
			}
		});
		

		tableViewer.setContentProvider(new ArrayContentProvider());
		tableViewer.setInput(availableInstances);
		
		CollectionComparator.compareCollection(selected, availableInstances, new CollectionComparator.Comparator<String, Instance>() {
			public boolean match(String o1, Instance o2) {return o2.getId().equals(o1);}
			public void matched(String o1, Instance o2) {
				tableViewer.setChecked(o2, true);
			}
		});
	}
	
	protected int[] getColumnSizes(int[] columnSizes) {
		int[] actualColumnSizes = new int[defaultColumnSizes.length];
		for (int i = 0; i < defaultColumnSizes.length; ++i) {
			if (columnSizes != null && columnSizes.length > i) {
				actualColumnSizes[i] = columnSizes[i];
			} else {
				actualColumnSizes[i] = defaultColumnSizes[i];
			}
		}
		return actualColumnSizes;
	}
	
	public List<Instance> getSelectedInstances() {
		List<Instance> selected = new ArrayList<>();
		Object[] checked = tableViewer.getCheckedElements();
		for (Object obj: checked) {
			selected.add((Instance)obj);
		}
		return selected;
	}
}