package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AWSOptionEndpoint;
import com.clustercontrol.ws.xcloud.AddEC2InstanceRequest;
import com.clustercontrol.ws.xcloud.EbsBlockDevice;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.ws.xcloud.Tag;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.aws.ui.dialogs.AWSResourceProvider;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateInstanceDialog.DialogData;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;
import com.clustercontrol.xcloud.ui.views.InstanceMonitorService;

public class CreateInstanceHandler implements ICloudOptionHandler, CloudStringConstants, AWSStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		final ILocation location = (ILocation)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveLocation);
		
		CreateInstanceDialog dialog = new CreateInstanceDialog(
				HandlerUtil.getActiveShell(event),
				location,
				MessageFormat.format(dlgComputeCreate, strAws),
				new AWSResourceProvider(location));
		
		final AddEC2InstanceRequest request = new AddEC2InstanceRequest();
		dialog.setDialogDataFactory(
			new CreateInstanceDialog.DialogDataFactory() {
				@Override
				public DialogData createDialogData() {
					return new DialogData() {
						@Override
						public String getName() {
							return request.getInstanceName();
						}
						@Override
						public void setName(String value) {
							request.setInstanceName(value);
						}
						@Override
						public String getMemo() {
							return request.getMemo();
						}
						@Override
						public void setMemo(String value) {
							request.setMemo(value);
						}
						@Override
						public List<Tag> getTags() {
							return request.getTags();
						}
						@Override
						public void setTags(List<Tag> value) {
							request.getTags().clear();
							request.getTags().addAll(value);
						}
						@Override
						public Boolean isAssociatePublicIpAddress() {
							return request.isAssociatePublicIpAddress();
						}
						@Override
						public void setAssociatePublicIpAddress(Boolean value) {
							request.setAssociatePublicIpAddress(value);
						}
						@Override
						public Boolean isDisableApiTermination() {
							return request.isDisableApiTermination();
						}
						@Override
						public void setDisableApiTermination(Boolean value) {
							request.setDisableApiTermination(value);
						}
						@Override
						public Boolean isEbsOptimized() {
							return request.isEbsOptimized();
						}
						@Override
						public void setEbsOptimized(Boolean value) {
							request.setEbsOptimized(value);
						}
						@Override
						public String getImageId() {
							return request.getImageId();
						}
						@Override
						public void setImageId(String value) {
							request.setImageId(value);
						}
						@Override
						public String getInstanceInitiatedShutdownBehavior() {
							return request.getInstanceInitiatedShutdownBehavior();
						}
						@Override
						public void setInstanceInitiatedShutdownBehavior(String value) {
							request.setInstanceInitiatedShutdownBehavior(value);
						}
						@Override
						public String getInstanceType() {
							return request.getInstanceType();
						}
						@Override
						public void setInstanceType(String value) {
							request.setInstanceType(value);
						}
						@Override
						public String getKeyName() {
							return request.getKeyName();
						}
						@Override
						public void setKeyName(String value) {
							request.setKeyName(value);
						}
						@Override
						public Boolean isMonitoring() {
							return request.isMonitoring();
						}
						@Override
						public void setMonitoring(Boolean value) {
							request.setMonitoring(value);
						}							@Override
						public Boolean isDeleteOnTermination() {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							return request.getRootBlockDevice().isDeleteOnTermination();
						}
						@Override
						public void setDeleteOnTermination(Boolean value) {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							request.getRootBlockDevice().setDeleteOnTermination(value);
						}
						@Override
						public Integer getIops() {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							return request.getRootBlockDevice().getIops();
						}
						@Override
						public void setIops(Integer value) {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							request.getRootBlockDevice().setIops(value);
						}
						@Override
						public Integer getVolumeSize() {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							return request.getRootBlockDevice().getVolumeSize();
						}
						@Override
						public void setVolumeSize(Integer value) {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							request.getRootBlockDevice().setVolumeSize(value);
						}
						@Override
						public String getVolumeType() {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							return request.getRootBlockDevice().getVolumeType();
						}
						@Override
						public void setVolumeType(String value) {
							if (request.getRootBlockDevice() == null)
								request.setRootBlockDevice(new EbsBlockDevice());
							request.getRootBlockDevice().setVolumeType(value);
						}
						@Override
						public List<String> getSecurityGroupIds() {
							return request.getSecurityGroupIds();
						}
						@Override
						public void setSecurityGroupIds(List<String> value) {
							request.getSecurityGroupIds().clear();
							request.getSecurityGroupIds().addAll(value);
						}
						@Override
						public String getSubnetId() {
							return request.getSubnetId();
						}
						@Override
						public void setSubnetId(String value) {
							request.setSubnetId(value);
						}
					};
				}
			});
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"), 
				MessageFormat.format(msgConfirmCreateComputeNode, request.getInstanceName()))) {
				
				try {
					AWSOptionEndpoint endpoint = location.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(AWSOptionEndpoint.class);
					final Instance instance = endpoint.addEC2Instance(location.getCloudScope().getId(), location.getId(), request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishCreateComputeNode, request.getInstanceName()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							location.updateLocation();
							InstanceMonitorService.getInstanceMonitorService().startMonitor(
								location.getCloudScope().getCloudScopes().getHinemosManager().getManagerName(),
								location.getCloudScope().getId(),
								location.getId(),
								instance.getId(),
								"running"
								);
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
