
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>facilityTypeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="facilityType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Root"/>
 *     &lt;enumeration value="CloudScope"/>
 *     &lt;enumeration value="Scope"/>
 *     &lt;enumeration value="Folder"/>
 *     &lt;enumeration value="Node"/>
 *     &lt;enumeration value="Instance"/>
 *     &lt;enumeration value="Entity"/>
 *     &lt;enumeration value="HNodeLinckage"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "facilityType")
@XmlEnum
public enum FacilityType {

    @XmlEnumValue("Root")
    ROOT("Root"),
    @XmlEnumValue("CloudScope")
    CLOUD_SCOPE("CloudScope"),
    @XmlEnumValue("Scope")
    SCOPE("Scope"),
    @XmlEnumValue("Folder")
    FOLDER("Folder"),
    @XmlEnumValue("Node")
    NODE("Node"),
    @XmlEnumValue("Instance")
    INSTANCE("Instance"),
    @XmlEnumValue("Entity")
    ENTITY("Entity"),
    @XmlEnumValue("HNodeLinckage")
    H_NODE_LINCKAGE("HNodeLinckage");
    private final String value;

    FacilityType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FacilityType fromValue(String v) {
        for (FacilityType c: FacilityType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
