/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.extensions;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

import com.clustercontrol.xcloud.Activator;

public final class ViewPluginUtil {
	private ViewPluginUtil(){}
	
	public static List<PluginView> getPluginViews(){
		List<PluginView> views = new LinkedList<PluginView>();
		
		IExtensionRegistry registry = Platform.getExtensionRegistry();

		// 拡張ポイントを取得
		IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + ".viewPlugin");

		for(IExtension extension: point.getExtensions()){
			for(IConfigurationElement element: extension.getConfigurationElements()){
				Integer priority = null;
				ViewPosition position = null;
				String viewId = null;
				
				// 要素名がview_pluginだった場合、ExtensionTypeの情報を取得
				if(element.getName().equals("view_plugin")){
					try {
						priority = Integer.parseInt(element.getAttribute("priority"));
						position = ViewPosition.valueOf(element.getAttribute("position"));
						viewId = element.getAttribute("view_id");
						
						assert priority != null: "priority is null.";
						assert position != null: "position is null.";
						assert viewId != null: "viewId is null.";
						
						views.add(new PluginView(priority, position, viewId));
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
		
		Collections.sort(views, new PluginViewComparator());
		return views;
	}
	
	public enum ViewPosition{
		left,
		top,
		right,
		middle,
		bottom;
	}
	
	public static class PluginView{
		private int priority;
		private ViewPosition position;
		private String id;
		
		public PluginView(int priority, ViewPosition position, String id){
			this.priority = priority;
			this.position = position;
			this.id = id;
		}
		
		public int getPriority() {
			return priority;
		}
		public void setPriority(int priority) {
			this.priority = priority;
		}
		public ViewPosition getPosition() {
			return position;
		}
		public void setPosition(ViewPosition position) {
			this.position = position;
		}
		public String getId() {
			return id;
		}
		public void setId(String id) {
			this.id = id;
		}
	}
	
	public static class PluginViewComparator implements Comparator<PluginView>{
		@Override
		public int compare(PluginView view1, PluginView view2) {
			int result;
			
			result = view1.getPosition().ordinal() - view2.getPosition().ordinal();
			
			if(result == 0){
				result = view1.getPriority() - view2.getPriority();
			}
			
			return result;
		}
	}
}
