/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IInstance;
import com.clustercontrol.xcloud.model.cloud.IInstanceBackupEntry;

public class DeleteInstanceSnapshotHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IInstanceBackupEntry entry = (IInstanceBackupEntry)selection.getFirstElement();
		final IInstance instance = entry.getBackup().getInstance();

		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			MessageFormat.format(msgConfirmDeleteSnapshot, entry.getName(), entry.getId()))) {
			
			List<String> entryIds = new ArrayList<>();
			for (@SuppressWarnings("rawtypes") Iterator iter = selection.iterator(); iter.hasNext();) {
				entryIds.add(((IInstanceBackupEntry)iter.next()).getId());
			}

			try {
				CloudEndpoint endpoint = entry.getBackup().getInstance().getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
				endpoint.deleteInstanceSnapshots(
						entry.getBackup().getInstance().getCloudScope().getId(),
						entry.getBackup().getInstance().getLocation().getId(),
						entry.getBackup().getInstance().getId(),
						entryIds
						);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					MessageFormat.format(msgFinishDeleteSnapshot, entry.getName(), entry.getId()));
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
			}

			Display.getCurrent().asyncExec(new Runnable() {
				@Override
				public void run() {
					instance.getBackup().update();
				}
			});
		}
		return null;
	}
}