package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.IInstance;
import com.clustercontrol.xcloud.ui.dialogs.ModifyInstanceTagDialog;

public class ModifyInstanceTagsHandler extends AbstractHandler implements CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection(event);
		IInstance instance = (IInstance)selection.getFirstElement();
		
		CloudEndpoint endpoint = instance.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);

		List<Instance> webInstances;
		try {
			webInstances = endpoint.getInstances(instance.getCloudScope().getId(), instance.getLocation().getId(), Arrays.asList(instance.getId()));
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);

			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
			return null;
		}
		
		if (webInstances.isEmpty()) {
			MessageDialog.openError(null, Messages.getString("failed"), String.format("not found instance of %s", instance.getId()));
			return null;
		}
		
		IWorkbenchPart part = HandlerUtil.getActivePart(event);
		ModifyInstanceTagDialog dialog = new ModifyInstanceTagDialog(part.getSite().getShell(), webInstances.get(0), instance.getCloudScope().getPlatformId());
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);
	
				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
				
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmModifyComputeNode, instance.getName(), instance.getId()))) {
				
				try {
					endpoint.modifyInstance(instance.getCloudScope().getId(), instance.getLocation().getId(), dialog.getOutput());
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						msgFinishModifyComputeNode);
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
