#!/bin/bash

#Copyright (C) 2015 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/install.cfg

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`
export EXECUTED_SCRIPT=${PROG}

########################################
# Function
########################################

function SIGINTExit()
{
	echo
	echo "Hinemos Installer is aborted. (SIGINT)"
	exit -1
}

########################################
# SHELL
########################################

# define trap
trap SIGINTExit 2

date +"### Hinemos Agent installer started at %Y-%m-%d %H:%M:%S ###" >> ${INSTALL_LOG}
${SCRIPT_DIR}/agent_installer_all -l en $@ 2>&1 | tee -a ${INSTALL_LOG}
RETURN=${PIPESTATUS[0]}
date +"### Hinemos Agent installer ended at %Y-%m-%d %H:%M:%S ###" >> ${INSTALL_LOG}

exit ${RETURN}
