#!/bin/bash

# Copyright (C) 2015 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

echo ""
echo ""
echo "########################################################"
echo "### Information Gathering Script of Agent (20150501) ###"
echo "###    Script started at `date '+%Y-%m-%d %T'`         ###"
echo "########################################################"
echo ""

########################################
#  Local Variable
########################################

HINEMOS_AGENT_HOME=`dirname $0`/../../

########################################
#  Function
########################################

function usage {
	echo "Usage: "
	echo "	$0 -vv  : Get information about OS INFORMATION"
	echo "	$0 -vvv : Get information about DETAIL"
	echo "	$0 -md5 : Get information about files's md5sum"
	return 0
}

function init {
	## Hinemos Agent env
	SCRIPT_DIR=$(cd $(dirname $0);pwd)
	. ${SCRIPT_DIR}/../../conf/hinemos_agent.cfg
}

function os {
	## cat /etc/lsb-release
	echo "### cat /etc/lsb-release ###"
	cat /etc/lsb-release
	echo -e "\n"

	## /proc/PID/environ
	echo "### /proc/PID/environ ###"
	xargs -n 1 -0 < /proc/`cat ${HINEMOS_AGENT_PID}`/environ
	echo -e "\n"

#	systemctl --version > /dev/null 2>&1
#	if [ $? -eq 0 ]; then
#		## systemctl list-dependencies | grep hinemos
#		echo "### systemctl list-dependencies | grep hinemos ###"
#		systemctl list-dependencies | grep hinemos
#		echo -e "\n"
#
#		## systemctl status hinemos_agent
#		echo "### systemctl status hinemos_agent"
#		systemctl status hinemos_agent
#		echo -e "\n"
#	else
#		## chkconfig --list | grep hinemos
#		echo "###  chkconfig --list | grep hinemos ###"
#		chkconfig --list | grep hinemos
#		echo -e "\n"
#	fi

	## dpkg -l
	echo "### dpkg -l ###"
	dpkg -l
	echo -e "\n"

	## cpuinfo
	echo "### /proc/cpuinfo ###"
	cat /proc/cpuinfo
	echo -e ""

	## meminfo
	echo "### /proc/meminfo ###"
	cat /proc/meminfo
	echo -e "\n"
	
	if [ -x sar ]; then
		## sar -P ALL
		echo "### sar -P ALL ###"
		sar -P ALL
		echo -e "\n"

		## sar -r
		echo "### sar -r ###"
		sar -r
		echo -e "\n"

		## sar -n DEV
		echo "### sar -n DEV ###"
		sar -n DEV
		echo -e "\n"
    
		## sar -n EDEV
		echo "### sar -n EDEV ###"
		sar -n EDEV
		echo -e "\n"
	else
		echo -e "### command 'sar' not installed ###\n"
	fi

	## vmstat -n
	if [ -x vmstat ]; then
		echo "### vmstat -n ###"
		vmstat -n
		echo -e "\n"
	else
		echo -e "### command 'vmstat' not installed ###\n"
	fi

	## iostat -d -x
	if [ -x iostat ]; then
		echo "### iostat -d -x ###"
		iostat -d -x
		echo -e ""
	else
		echo -e "### command 'iostat' not installed ###\n"
	fi

	## ps -H auxwww
	echo "### ps -H auxwww ###"
	ps -H auxwww
	echo -e "\n"

	netstat --version > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		## netstat -s
		echo "### netstat -s ###"
		netstat -s
		echo -e "\n"

		## netstat -anpo
		echo "### netstat -anpo ###"
		netstat -anpo
		echo -e "\n"
	else
		## ss -s
		echo "### ss -s ###"
		ss -s
		echo -e "\n"

		## ss -anpo
		echo "### ss -anpot ###"
		ss -anpot
		echo -e "\n"
		echo "### ss -anpou ###"
		ss -anpou
		echo -e "\n"
	fi

	## df
	echo "### df ###"
	df
	echo -e "\n"
	
	## df -i
	echo "### df -i ###"
	df -i
	echo -e "\n"
	
	## uptime
	echo "### uptime ###"
	uptime
	echo -e "\n"
	
	## /proc/slabinfo
	echo "### /proc/slabinfo ###"
	cat /proc/slabinfo
	echo -e "\n"
	
	## /proc/vmstat
	echo "### /proc/vmstat ###"
	cat /proc/vmstat
	echo -e "\n"
}

function md5sum {
	## md5sum
	echo "### md5sum ###"
	cd ${HINEMOS_AGENT_HOME}
	find `ls --ignore={var,download}` -type f | xargs md5sum
	echo -e "\n"
}

function detail {
	## lsof
	echo "### lsof ###"
	lsof
	echo -e "\n"
  
	md5sum
}

########################################
# Main
########################################

# check parameters
if [ $# -eq 0 ]; then
	usage
	exit 1
fi
for OPT in $@; do
	case $OPT in
		--help|-h)
			usage
			exit 0
			;;
	esac
done

case "$@" in
	-vv)
		init
		os
		;;
	-vvv)
		init
		os
		detail
		;;
	-md5)
		md5sum
		;;
	*)
		usage
		exit 1
esac

echo ""
echo "###################################################"
echo "###     Script ended at `date '+%Y-%m-%d %T'`     ###"
echo "###################################################"

exit 0
