/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Define language name of title
 */
(function(__){
	
	$.extend(__,{
		/********************************************************
		 * Declare perspective titles
		 */
		getPersTitle: function(name){
			var pers_list = {
				jobmanagement: "${job.management}"
				,monitor     : "${monitor.management}"
				,repository  : "${repository}"
			}
			
			// Check name
			if(name){
				if(pers_list[name]){
					return pers_list[name];
				}else{
					return name;
				}
				return pers_list[name];
			}else{
				return pers_list;
			}
		}
		
		,/*******************************************************
		 * Declare views titles
		 */
		getViewTitle: function(per_nm, vw_nm){
			var per 
			,view_list = {
				jobmanagement: {
					list                : "${view.job.list}"
					,schedule           : "${view.job.schedule}"
					,history            : "${view.job.history}"
					,run_schedule       : "${view.job.run.schedule}"
					,job_detail         : "${view.job.job.detail}"
					,run_schedule_detail: "${view.job.run.schedule.detail}"
					,node_detail        : "${view.job.node.detail}"
					,forward_file       : "${view.job.forward.file}"
				}
				,monitor: {
					event  : "${view.monitor.event}"
					,scope : "${view.monitor.scope}"
					,status: "${view.monitor.status}"
				}
				,repository: {
					 node           : "${view.repository.node}"
					,assigned_scopes: "${view.repository.assigned.scopes}"
					,scope          : "${view.repository.scope}"
					,node_property  : "${view.repository.node.property}"
				}
			}
			;
			
			// Check declaring of perspective
			if(!(per = view_list[per_nm])){
				return per_nm;
			}
			
			// Get view
			if(!(per[vw_nm])){
				return vw_nm;
			}else{
				return per[vw_nm];
			}
		}
		
		,/*******************************************************
		 * Declare dialog titles
		 */
		getDlgTitle: function(fnc_nm){
			var dlg_list = {
				hinemosagent: {
					list   : "${dialog.agent.list}"
					,modify: "${dialog.agent.create.modify}"
				}
				,http: {
					list   : "${dialog.http.list}"
					,modify: "${dialog.http.create.modify}"
					,string: "${dialog.monitor.run.create.modify.string}"
				}
				,jobmanagement: {
					filter_histories: "${dialog.job.filter.histories}"
				}
				,logtransfer: {
					list   : "${dialog.logtransfer.list}"
					,modify: "${dialog.logtransfer.create.modify}"
				}
				,monitor: {
					filter_events : "${dialog.monitor.filter.events}"
					,filter_status: "${dialog.monitor.filter.status}"
					,events_info  : "${dialog.monitor.info.events}"
					,message_org  : "${message.org}"
				}
				,performance: {
					list   : "${dialog.performance.monitor.list}"
					,modify: "${dialog.performance.monitor.create.modify}"
				}
				,ping: {
					list   : "${dialog.ping.list}"
					,modify: "${dialog.ping.create.modify}"
				}
				,process: {
					list   : "${dialog.process.list}"
					,create: "${dialog.process.create.modify}"
				}
				,repository: {
					filter_nodes: "${dialog.repository.filter.nodes}"
				}
				,snmp: {
					list   : "${dialog.snmp.list}"
					,modify: "${dialog.snmp.create.modify}"
					,string: "${dialog.monitor.run.create.modify.string}"
				}
				,sql: {
					list   : "${dialog.sql.list}"
					,modify: "${dialog.sql.create.modify}"
					,string: "${dialog.monitor.run.create.modify.string}"
				}
				,syslogng: {
					list   : "${dialog.syslog-ng.list}"
					,create: "${dialog.syslog-ng.create.modify}"
				}
			}
			;
			
			if(dlg_list[fnc_nm]){
				return dlg_list[fnc_nm];
			}else{
				return fnc_nm;
			}
		}
	});
	
})(cm);