/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.accesscontrol.business;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;

import com.necsoft.hinemos.webclient.accesscontrol.form.UserForm;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for check LoginAuth
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class LoginAuthBusiness {

    /**
     * This method used for check LoginAuth
     * 
     * @param form : UserForm
     * @param loginManager : LoginManager
     * @return void
     * @throws NamingException
     * @throws LoginException
     * @throws RemoteException
     * @throws CreateException     * 
     */
    public void loginAuth(UserForm form, LoginManager loginManager)
            throws NamingException, LoginException, RemoteException,
            CreateException {
        loginManager.login(form.getUserName(), form.getPassword(),
                form.getUrlServer());
    }
}
