/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobManagementUserInfo;
import com.clustercontrol.jobmanagement.bean.JobTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobTree;
import com.necsoft.hinemos.webclient.jobmanagement.bean.JobTreeBean;
import com.necsoft.hinemos.webclient.jobmanagement.json.JobTreeJson;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;

/**
 * This class used for get Job tree
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetJobTreeBusiness {

    private JobTreeItem jobTreeItem;

    /**
     * Get detail of Facility scope list
     * 
     * @param namingContext
     *            NamingContext
     * @return JobTreeJson
     * @throws HinemosWebException
     */
    public JobTreeItem getJobTree(NamingContext namingContext, Locale locale)
            throws HinemosWebException {

        // JobTree を取得
        GetJobTree getJobTree = new GetJobTree();
        getJobTree.setNamingContext(namingContext);

        // ファシリティ一覧を取得
        jobTreeItem = getJobTree.getJobTree(false, locale);

        if (jobTreeItem == null) {
            // エラー発生する場合、
            throw new HinemosWebInvalidDataException("exception.job.tree");
        }
        return jobTreeItem;
    }

    public JobTreeJson doConvertToJson(JobTreeItem jobTreeItem, String userName) {
        // Create data JSON
        ArrayList<JobTreeItem> treeItems = jobTreeItem.getChildren();
        JobTreeJson jobTreeJs = new JobTreeJson();
        for (int cnt = 0; cnt < treeItems.size(); cnt++) {
            jobTreeJs
                    .addJobTree(treeItem2TreeBean(treeItems.get(cnt), userName));
        }

        return jobTreeJs;
    }

    /**
     * Convert JobTreeItem to FacilityTreeBean
     * 
     * @param treeItem
     * @param path
     * @param key
     * @return JobTreeBean
     */
    private JobTreeBean treeItem2TreeBean(JobTreeItem treeItem, String userName) {
        JobTreeBean treeBean = new JobTreeBean();
        JobInfo jobInfo = treeItem.getData();

        StringBuffer title = new StringBuffer(jobInfo.getName());
        String jobId = jobInfo.getId();
        int type = jobInfo.getType();

        if (type == JobConstant.TYPE_COMPOSITE) {
            treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOB_COMPOSITE);
        } else {
            // Append title
            title.append(" (");
            title.append(jobId);
            title.append(")");

            // Set data for Node
            treeBean.setJobData(getJobData(jobInfo));
        }

        // Set component of JobTreeBean
        treeBean.setTitle(StringEscapeUtils.escapeHtml(title.toString()));
        treeBean.setTooltip(StringEscapeUtils.escapeHtml(title.toString()));
        treeBean.setJobId(jobId);
        treeBean.setPath(StringEscapeUtils.escapeHtml(treeItem.getPath()));
        treeBean.setJobunitId(jobInfo.getJobunitId());

        // Set children of node
        if (type == JobConstant.TYPE_FILEJOB) {
            treeBean.setAddClass(JobManagementConstants.CSS_TREE_FILEJOB);
        } else if (type == JobConstant.TYPE_JOB) {
            treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOB);
        } else {
            // Set class for FacilityTreeBean
            treeBean.setIsFolder(true);
            if (type == JobConstant.TYPE_JOBUNIT) {
                if ((userName != null)
                        && checkPermissionJobunit(jobInfo.getManagementUser(),
                                userName)) {
                    treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOBUNIT);
                } else {
                    treeBean.setAddClass(JobManagementConstants.CSS_FORBIDEDEN_TREE_JOBUNIT);
                }
            } else if (type == JobConstant.TYPE_JOBNET) {
                treeBean.setAddClass(JobManagementConstants.CSS_TREE_JOBNET);
            }

            // Set children for this JobTreeBean
            ArrayList<JobTreeItem> treeItems = treeItem.getChildren();

            // 子ノードリストを取得
            for (int cnt = 0; cnt < treeItems.size(); cnt++) {
                treeBean.addChildren(treeItem2TreeBean(treeItems.get(cnt),
                        userName));
            }
        }

        return treeBean;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param listInfoData
     *            : ArrayList<?>
     * @return GridDataJson
     */
    private Map<String, Object> getJobData(JobInfo jobInfo) {

        Map<String, Object> jobData = new HashMap<String, Object>();

        jobData.put(JobMappingUtil.getJobName(JobTableDefine.JOB_ID),
                StringEscapeUtils.escapeHtml(jobInfo.getId()));
        jobData.put(JobMappingUtil.getJobName(JobTableDefine.JOB_NAME),
                StringEscapeUtils.escapeHtml(jobInfo.getName()));
        jobData.put(JobMappingUtil.getJobName(JobTableDefine.JOB_TYPE),
                jobInfo.getType());

        JobCommandInfo exec = jobInfo.getCommand();
        if (exec instanceof JobCommandInfo) {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.FACILITY_ID),
                    StringEscapeUtils.escapeHtml(exec.getFacilityID()));
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.SCOPE),
                    StringEscapeUtils.escapeHtml((String) exec.getScope()));
        } else {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.FACILITY_ID),
                    null);
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.SCOPE), null);
        }

        JobWaitRuleInfo waitRule = jobInfo.getWaitRule();
        if (waitRule instanceof JobWaitRuleInfo) {
            if (waitRule.getObject() != null && waitRule.getObject().size() > 0) {
                jobData.put(
                        JobMappingUtil.getJobName(JobTableDefine.WAIT_RULE),
                        YesNoConstant.TYPE_YES);
            } else {
                jobData.put(
                        JobMappingUtil.getJobName(JobTableDefine.WAIT_RULE),
                        YesNoConstant.TYPE_NO);
            }
        } else {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.WAIT_RULE),
                    YesNoConstant.TYPE_NO);
        }

        jobData.put(JobMappingUtil.getJobName(JobTableDefine.CREATE_USER),
                jobInfo.getCreateUser());
        if (jobInfo.getCreateTime() != null) {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.CREATE_TIME),
                    jobInfo.getCreateTime().getTime());
        } else {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.CREATE_TIME),
                    null);
        }
        jobData.put(JobMappingUtil.getJobName(JobTableDefine.UPDATE_USER),
                jobInfo.getUpdateUser());
        if (jobInfo.getUpdateTime() != null) {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.UPDATE_TIME),
                    jobInfo.getUpdateTime().getTime());
        } else {
            jobData.put(JobMappingUtil.getJobName(JobTableDefine.UPDATE_TIME),
                    null);
        }
        // Set other content
        return jobData;
    }

    private boolean checkPermissionJobunit(
            ArrayList<JobManagementUserInfo> arrJobManagementUser,
            String userName) {
        if (arrJobManagementUser == null) {
            return false;
        }

        if (arrJobManagementUser.size() == 0) {
            return true;
        }

        for (int count = 0; count < arrJobManagementUser.size(); count++) {
            JobManagementUserInfo mngUserInfo = arrJobManagementUser.get(count);
            if (mngUserInfo.getUserId().equals(userName)) {
                return true;
            }
        }

        return false;
    }
}
