/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetScheduleTableDefine;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

/**
 * This class used for get header list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetScheduleTableDefineBusiness {

    /**
     * Get header list
     * 
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebHeaderInvalidException
     */
    public ArrayList<TableColumnInfoJs> getScheduleTableDefine(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // イベントテーブルヘッダー定義データ(JobTableDefine)を取得
        tblDefine = GetScheduleTableDefine.get(locale);

        // イベントテーブルヘッダー定義データの項目数チェック
        if (tblDefine.size() != JobManagementConstants.SCHEDULE_HEADER_NUM) {
            // 項目数が不足の場合
            throw new HinemosWebHeaderInvalidException(
                    "exception.job.schedule.number.header");
        }

        return tblDefine;
    }

    /**
     * Convert header to JSON structure
     * 
     * @param ArrayList
     *            <TableColumnInfoJs>
     * @return GridHeaderJson
     */
    public GridHeaderJson doConvertToJson(ArrayList<TableColumnInfoJs> tblDefine) {
        // Create JSON
        GridHeaderJson result = new GridHeaderJson();
        result.setColNames(ConvertListUtil.columnInfoToColNames(tblDefine));
        result.setColModel(ConvertListUtil.columnInfoToColModel(tblDefine));

        result.setRowNum(JobManagementConstants.ROW_NUM);
        result.setSortname(ScheduleTableDefine.SORT_COLUMN_INDEX);
        result.setSortorder(SortOrderUtil
                .getJsString(ScheduleTableDefine.SORT_ORDER));

        return result;
    }
}
