/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.JobInfoNotFoundException;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetForwardFileBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.ForwardFileForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * 監視[スコープ]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * ForwardFileにSessionBean経由でアクセスし、スコープ一覧情報を取得します。
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetForwardFileServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetForwardFileServlet.class);

    /**
     * Get ForwardFile list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException 
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException, HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            // Get table tree
            result = doLoadListInfoData(request, namingContext);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }

        return result;
    }

    /**
     * Get ForwardFile list
     * 
     * @param request
     *            : HttpServletRequest
     * @param namingContext
     *            : NamingContext
     * @throws HinemosWebRemoteException
     * @throws HinemosWebInvalidRequestParameterException
     * @throws HinemosWebInvalidNumberSizeDataException
     * @throws HinemosUnknownException
     * @throws JobInfoNotFoundException
     */
    private GridDataJson doLoadListInfoData(HttpServletRequest request,
            NamingContext namingContext) throws HinemosWebException {
        ForwardFileForm form = new ForwardFileForm();
        PopulateBeanUtils.populateBean(form, request);

        // Check parameters of request
        if (!isValidRequestParam(form)) {
            throw new HinemosWebInvalidRequestParameterException();
        }

        GetForwardFileBusiness business = new GetForwardFileBusiness();

        List<List<Object>> listItem = business.getForwardFile(form,
                namingContext);

        return doLoadDataJson(listItem);
    }

    /**
     * Check valid parameter
     * 
     * @param form
     *            : ForwardFileForm
     * @return boolean
     */
    private boolean isValidRequestParam(ForwardFileForm form) {
        boolean isValid = true;
        String sessionId = form.getSessionId();
        String jobUnitId = form.getJobunitId();
        String jobId = form.getJobId();

        // Check request sessionId (manager)
        if (sessionId == null || sessionId.equals("")) {
            isValid = false;
            logUtils.error("sessionId is invalid", sessionId);
        }

        // Check request jobUnitId (manager)
        if (jobUnitId == null || jobUnitId.equals("")) {
            isValid = false;
            logUtils.error("jobUnitId is invalid", jobUnitId);
        }

        // Check request jobId (manager)
        if (jobId == null || jobId.equals("")) {
            isValid = false;
            logUtils.error("jobId is invalid", jobId);
        }

        return isValid;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param listItem
     *            : ArrayList<JobForwardFile>
     */
    private GridDataJson doLoadDataJson(List<List<Object>> listItem) {
        GetForwardFileBusiness business = new GetForwardFileBusiness();
        return business.doConvertToJson(listItem);
    }
}