/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.HistoryForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get History info
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetHistoryServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetHistoryServlet.class);

    /**
     * Get History info
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            List<List<Object>> listInfoData = doLoadListInfoData(request,
                    namingContext);

            // Create JSON
            result = doLoadDataJson(listInfoData);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }

        return result;
    }

    /**
     * Get History info
     * 
     * @param request
     *            : HttpServletRequest
     * @param namingContext
     *            : NamingContext
     * @return ArrayList<JobHistory>
     * @throws Exception
     */
    private List<List<Object>> doLoadListInfoData(HttpServletRequest request,
            NamingContext namingContext) throws HinemosWebException {
        //
        HistoryForm form = new HistoryForm();
        PopulateBeanUtils.populateBean(form, request);
        List<List<Object>> list;

        // Check filter
        if (form.isFilter()) {
            list = processFitler(request, form, namingContext);
        } else {
            list = processNoneFilter(form, namingContext);
        }

        return list;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param listInfoData
     *            : ArrayList<JobHistory>
     * @return GridDataJson
     */
    private GridDataJson doLoadDataJson(List<List<Object>> list) {
        GetHistoryBusiness business = new GetHistoryBusiness();
        return business.doConvertToJson(list);
    }

    private List<List<Object>> processFitler(HttpServletRequest request,
            HistoryForm form, NamingContext namingContext)
            throws HinemosWebException {
        Property condition = doLoadCondition(request);
        GetHistoryBusiness business = new GetHistoryBusiness();
        return business.getHistory(form, condition, namingContext);
    }

    private List<List<Object>> processNoneFilter(HistoryForm form,
            NamingContext namingContext) throws HinemosWebException {
        GetHistoryBusiness business = new GetHistoryBusiness();
        return business.getHistory(form, null, namingContext);
    }

    private Property doLoadCondition(HttpServletRequest request)
            throws HinemosWebException {

        GetHistoryFilterPropertyBusiness filterProperties = new GetHistoryFilterPropertyBusiness();

        Property condition = filterProperties.getHistoryFilterProperty(request
                .getLocale());
        convertCondition(request, condition);

        return condition;
    }
}