/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;

import com.clustercontrol.jobmanagement.bean.ForwardFileTableDefine;
import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.bean.JobForwardFile;
import com.clustercontrol.jobmanagement.bean.JobHistory;
import com.clustercontrol.jobmanagement.bean.JobNodeDetail;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.bean.NodeDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;

/**
 * 表示用のリストに変換するクラス
 **/
public class ConvertListUtil {

    /**************************************************************************
     * Schedule
     */
    /**
     * @param list
     * @return
     */
    public static List<List<Object>> jobScheduleListToArrayList(
            List<JobSchedule> list) {

        List<List<Object>> ret = new ArrayList<List<Object>>();
        Iterator<JobSchedule> itr = list.iterator();

        while (itr.hasNext()) {
            List<Object> schedule = new ArrayList<Object>();
            JobSchedule jobSche = itr.next();

            Object creatTime;
            Object updateTime;

            // Check startDate
            if (jobSche.getCreateTime() == null) {
                creatTime = null;
            } else {
                creatTime = jobSche.getCreateTime().getTime();
            }

            // Check endDate
            if (jobSche.getUpdateTime() == null) {
                updateTime = null;
            } else {
                updateTime = jobSche.getUpdateTime().getTime();
            }

            schedule.add(ScheduleTableDefine.SCHE_ID, (jobSche.getId()));
            schedule.add(ScheduleTableDefine.SCHE_NAME, (jobSche.getName()));
            schedule.add(ScheduleTableDefine.JOB_ID, (jobSche.getJobId()));
            schedule.add(ScheduleTableDefine.JOB_NAME, (jobSche.getJobName()));
            schedule.add(ScheduleTableDefine.JOBUNIT_ID,
                    (jobSche.getJobunitId()));
            schedule.add(ScheduleTableDefine.CALENDAR_ID,
                    (jobSche.getCalendarId()));
            schedule.add(ScheduleTableDefine.SCHEDULE, jobSche.getSchedule());
            schedule.add(ScheduleTableDefine.VALID, jobSche.getValid());
            schedule.add(ScheduleTableDefine.CREATE_USER,
                    jobSche.getCreateUser());
            schedule.add(ScheduleTableDefine.CREATE_TIME, creatTime);
            schedule.add(ScheduleTableDefine.UPDATE_USER,
                    jobSche.getUpdateUser());
            schedule.add(ScheduleTableDefine.UPDATE_TIME, updateTime);

            ret.add(schedule);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeScheduleList(List<List<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            if (row.get(ScheduleTableDefine.SCHE_ID) != null) {
                row.set(ScheduleTableDefine.SCHE_ID, StringEscapeUtils
                        .escapeHtml((row.get(ScheduleTableDefine.SCHE_ID)
                                .toString())));
            }

            if (row.get(ScheduleTableDefine.SCHE_NAME) != null) {
                row.set(ScheduleTableDefine.SCHE_NAME, StringEscapeUtils
                        .escapeHtml((row.get(ScheduleTableDefine.SCHE_NAME)
                                .toString())));
            }

            if (row.get(ScheduleTableDefine.JOB_ID) != null) {
                row.set(ScheduleTableDefine.JOB_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                ScheduleTableDefine.JOB_ID).toString()));
            }

            if (row.get(ScheduleTableDefine.JOB_NAME) != null) {
                row.set(ScheduleTableDefine.JOB_NAME,
                        StringEscapeUtils.escapeHtml(row.get(
                                ScheduleTableDefine.JOB_NAME).toString()));
            }

            if (row.get(ScheduleTableDefine.JOBUNIT_ID) != null) {
                row.set(ScheduleTableDefine.JOBUNIT_ID, StringEscapeUtils
                        .escapeHtml((row.get(ScheduleTableDefine.JOBUNIT_ID)
                                .toString())));
            }

            if (row.get(ScheduleTableDefine.CALENDAR_ID) != null) {
                row.set(ScheduleTableDefine.CALENDAR_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                ScheduleTableDefine.CALENDAR_ID).toString()));
            }

            if (row.get(ScheduleTableDefine.CREATE_USER) != null) {
                row.set(ScheduleTableDefine.CREATE_USER,
                        StringEscapeUtils.escapeHtml(row.get(
                                ScheduleTableDefine.CREATE_USER).toString()));
            }

            if (row.get(ScheduleTableDefine.UPDATE_USER) != null) {
                row.set(ScheduleTableDefine.UPDATE_USER,
                        row.get(ScheduleTableDefine.UPDATE_USER));
            }
        }

    }

    /**************************************************************************
     * History
     */
    public static List<List<Object>> jobHistoryListToArrayList(
            List<JobHistory> list) {

        List<List<Object>> ret = new ArrayList<List<Object>>();
        Iterator<JobHistory> itr = list.iterator();

        while (itr.hasNext()) {
            List<Object> history = new ArrayList<Object>();
            JobHistory jobHist = itr.next();

            Object scheduleStartDate;
            Object startDate;
            Object endDate;

            // Check scheduleStartDate
            if (jobHist.getScheduleDate() == null) {
                scheduleStartDate = null;
            } else {
                scheduleStartDate = jobHist.getScheduleDate().getTime();
            }

            // Check startDate
            if (jobHist.getStartDate() == null) {
                startDate = null;
            } else {
                startDate = jobHist.getStartDate().getTime();
            }

            // Check endDate
            if (jobHist.getEndDate() == null) {
                endDate = null;
            } else {
                endDate = jobHist.getEndDate().getTime();
            }

            history.add(HistoryTableDefine.STATUS, jobHist.getStatus());
            history.add(HistoryTableDefine.END_STATUS, jobHist.getEndStatus());
            history.add(HistoryTableDefine.END_VALUE, jobHist.getEndValue());
            history.add(HistoryTableDefine.SESSION_ID, jobHist.getSessionId());
            history.add(HistoryTableDefine.JOB_ID, jobHist.getJobId());
            history.add(HistoryTableDefine.JOB_NAME, jobHist.getJobName());
            history.add(HistoryTableDefine.JOBUNIT_ID, jobHist.getJobunitId());
            history.add(HistoryTableDefine.JOB_TYPE, jobHist.getJobType());
            history.add(HistoryTableDefine.FACILITY_ID, jobHist.getFacilityId());
            history.add(HistoryTableDefine.SCOPE, jobHist.getScope());
            history.add(HistoryTableDefine.SCHEDULED_START_TIME,
                    scheduleStartDate);
            history.add(HistoryTableDefine.START_RERUN_TIME, startDate);
            history.add(HistoryTableDefine.END_SUSPEND_TIME, endDate);
            history.add(HistoryTableDefine.TRIGGER_TYPE,
                    jobHist.getJobTriggerType());
            history.add(HistoryTableDefine.TRIGGER_INFO,
                    jobHist.getTriggerInfo());

            ret.add(history);
        }

        return ret;
    }

    public static void sanitizeHistoryList(List<List<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            if (row.get(HistoryTableDefine.JOB_ID) != null) {
                row.set(HistoryTableDefine.JOB_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                HistoryTableDefine.JOB_ID).toString()));
            }

            if (row.get(HistoryTableDefine.JOB_NAME) != null) {
                row.set(HistoryTableDefine.JOB_NAME,
                        StringEscapeUtils.escapeHtml(row.get(
                                HistoryTableDefine.JOB_NAME).toString()));
            }

            if (row.get(HistoryTableDefine.JOBUNIT_ID) != null) {
                row.set(HistoryTableDefine.JOBUNIT_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                HistoryTableDefine.JOBUNIT_ID).toString()));
            }

            if (row.get(HistoryTableDefine.FACILITY_ID) != null) {
                row.set(HistoryTableDefine.FACILITY_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                HistoryTableDefine.FACILITY_ID).toString()));
            }

            if (row.get(HistoryTableDefine.SCOPE) != null) {
                row.set(HistoryTableDefine.SCOPE,
                        StringEscapeUtils.escapeHtml(row.get(
                                HistoryTableDefine.SCOPE).toString()));
            }

            if (row.get(HistoryTableDefine.TRIGGER_INFO) != null) {
                row.set(HistoryTableDefine.TRIGGER_INFO,
                        StringEscapeUtils.escapeHtml(row.get(
                                HistoryTableDefine.TRIGGER_INFO).toString()));
            }
        }
    }

    /**************************************************************************
     * Run schedule
     */
    public static List<List<Object>> sanitizeRunScheduleList(
            ArrayList<ArrayList<Object>> list) {

        List<List<Object>> ret = new ArrayList<List<Object>>();
        Iterator<ArrayList<Object>> itr = list.iterator();

        while (itr.hasNext()) {
            List<Object> runSchedule = new ArrayList<Object>();
            ArrayList<Object> jobRunSche = itr.next();

            for (int count = 0; count < jobRunSche.size(); count++) {
                String value;

                // Check value
                if (jobRunSche.get(count) == null) {
                    value = null;
                } else {
                    value = StringEscapeUtils.escapeHtml(jobRunSche.get(count)
                            .toString());
                }
                runSchedule.add(count, value);
            }

            ret.add(runSchedule);
        }

        return ret;
    }

    /**************************************************************************
     * Job node detail
     */
    public static List<List<Object>> jobNodeDetailListToArrayList(
            ArrayList<JobNodeDetail> list) {
        List<List<Object>> ret = new ArrayList<List<Object>>();
        Iterator<JobNodeDetail> itr = list.iterator();

        while (itr.hasNext()) {
            List<Object> nodeDetail = new ArrayList<Object>();
            JobNodeDetail jobNodeDetail = itr.next();

            Long startDate;
            Long endDate;

            // Check startDate
            if (jobNodeDetail.getStartDate() == null) {
                startDate = null;
            } else {
                startDate = jobNodeDetail.getStartDate().getTime();
            }

            // Check endDate
            if (jobNodeDetail.getEndDate() == null) {
                endDate = null;
            } else {
                endDate = jobNodeDetail.getEndDate().getTime();
            }

            nodeDetail.add(NodeDetailTableDefine.STATUS,
                    jobNodeDetail.getStatus());
            nodeDetail.add(NodeDetailTableDefine.RETURN_VALUE,
                    jobNodeDetail.getEndValue());
            nodeDetail
                    .add(NodeDetailTableDefine.FACILITY_ID, StringEscapeUtils
                            .escapeHtml(jobNodeDetail.getFacilityId()));
            nodeDetail.add(NodeDetailTableDefine.FACILITY_NAME,
                    StringEscapeUtils.escapeHtml(jobNodeDetail.getNodeName()));
            nodeDetail.add(NodeDetailTableDefine.START_RERUN_TIME, startDate);
            nodeDetail.add(NodeDetailTableDefine.END_SUSPEND_TIME, endDate);
            nodeDetail.add(NodeDetailTableDefine.MESSAGE,
                    StringEscapeUtils.escapeHtml(jobNodeDetail.getMessage()));
            ret.add(nodeDetail);
        }

        return ret;
    }

    /**************************************************************************
     * Forward file
     */
    /**
     * @param list
     * @return
     */
    public static List<List<Object>> jobForwardFileListToArrayList(
            ArrayList<JobForwardFile> list) {
        List<List<Object>> ret = new ArrayList<List<Object>>();
        Iterator<JobForwardFile> itr = list.iterator();

        while (itr.hasNext()) {
            List<Object> forwardFile = new ArrayList<Object>();
            JobForwardFile jobForwarFile = itr.next();

            Object startDate;
            Object endDate;

            // Check startDate
            if (jobForwarFile.getStartDate() == null) {
                startDate = null;
            } else {
                startDate = jobForwarFile.getStartDate().getTime();
            }

            // Check endDate
            if (jobForwarFile.getEndDate() == null) {
                endDate = null;
            } else {
                endDate = jobForwarFile.getEndDate().getTime();
            }

            forwardFile.add(ForwardFileTableDefine.STATUS,
                    jobForwarFile.getStatus());
            forwardFile.add(ForwardFileTableDefine.END_STATUS,
                    jobForwarFile.getEndStatus());
            forwardFile.add(ForwardFileTableDefine.FILE_NAME,
                    jobForwarFile.getFile());
            forwardFile.add(ForwardFileTableDefine.SRC_FACILITY_ID,
                    jobForwarFile.getSrcFacility());
            forwardFile.add(ForwardFileTableDefine.SRC_FACILITY_NAME,
                    jobForwarFile.getSrcFacilityName());
            forwardFile.add(ForwardFileTableDefine.DEST_FACILITY_ID,
                    jobForwarFile.getDstFacilityId());
            forwardFile.add(ForwardFileTableDefine.DEST_FACILITY_NAME,
                    jobForwarFile.getDstFacilityName());
            forwardFile.add(ForwardFileTableDefine.START_RERUN_TIME, startDate);
            forwardFile.add(ForwardFileTableDefine.END_SUSPEND_TIME, endDate);

            ret.add(forwardFile);
        }

        return ret;
    }

    /**
     * @param list
     */
    public static void sanitizeForwardFileList(List<List<Object>> list) {
        for (int count = 0; count < list.size(); count++) {
            List<Object> row = list.get(count);

            if (row.get(ForwardFileTableDefine.FILE_NAME) != null) {
                row.set(ForwardFileTableDefine.FILE_NAME,
                        StringEscapeUtils.escapeHtml(row.get(
                                ForwardFileTableDefine.FILE_NAME).toString()));
            }

            if (row.get(ForwardFileTableDefine.SRC_FACILITY_ID) != null) {
                String srcFacilityId = StringEscapeUtils.escapeHtml(row.get(
                        ForwardFileTableDefine.SRC_FACILITY_ID).toString());
                row.set(ForwardFileTableDefine.SRC_FACILITY_ID, srcFacilityId);
            }

            if (row.get(ForwardFileTableDefine.SRC_FACILITY_NAME) != null) {
                row.set(ForwardFileTableDefine.SRC_FACILITY_NAME,
                        StringEscapeUtils.escapeHtml(row.get(
                                ForwardFileTableDefine.SRC_FACILITY_NAME)
                                .toString()));
            }

            if (row.get(ForwardFileTableDefine.DEST_FACILITY_ID) != null) {
                row.set(ForwardFileTableDefine.DEST_FACILITY_ID,
                        StringEscapeUtils.escapeHtml(row.get(
                                ForwardFileTableDefine.DEST_FACILITY_ID)
                                .toString()));
            }

            if (row.get(ForwardFileTableDefine.DEST_FACILITY_NAME) != null) {
                row.set(ForwardFileTableDefine.DEST_FACILITY_NAME,
                        StringEscapeUtils.escapeHtml(row.get(
                                ForwardFileTableDefine.DEST_FACILITY_NAME)
                                .toString()));
            }
        }
    }
}
