/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.util.ArrayList;
import java.util.Date;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.jobmanagement.bean.JobHistoryFilter;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.bean.NodeOperationInfo;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.util.PropertyUtil;

/**
 * This class used for set filter data
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class JobPropertyUtil {

    @SuppressWarnings("rawtypes")
    public static NodeOperationInfo property2nodeOperation(Property property) {
        NodeOperationInfo info = new NodeOperationInfo();

        // セッションID取得
        ArrayList values = PropertyUtil.getPropertyValue(property,
                JobOperationConstant.SESSION);
        if (values.get(0) instanceof String
                && ((String) values.get(0)).length() > 0)
            info.setSessionId((String) values.get(0));

        // ジョブユニットID取得
        values = PropertyUtil.getPropertyValue(property,
                JobOperationConstant.JOB_UNIT);
        if (values.get(0) instanceof String
                && ((String) values.get(0)).length() > 0)
            info.setJobunitId((String) values.get(0));

        // ジョブID取得
        values = PropertyUtil.getPropertyValue(property,
                JobOperationConstant.JOB);
        if (values.get(0) instanceof String
                && ((String) values.get(0)).length() > 0)
            info.setJobId((String) values.get(0));

        // ファシリティID取得
        values = PropertyUtil.getPropertyValue(property,
                JobOperationConstant.FACILITY);
        if (values.size() > 0 && values.get(0) instanceof String
                && ((String) values.get(0)).length() > 0)
            info.setFacilityId((String) values.get(0));

        // 制御取得
        values = PropertyUtil.getPropertyValue(property,
                JobOperationConstant.CONTROL);
        Integer control = null;
        if (values.get(0) instanceof String) {
            String controlString = (String) values.get(0);
            control = Integer.valueOf(OperationConstant
                    .stringToType(controlString));
            info.setControl(control);
        }

        // 終了値取得
        values = PropertyUtil.getPropertyValue(property,
                JobOperationConstant.END_VALUE);
        if (values.size() > 0 && values.get(0) instanceof Integer)
            info.setEndValue((Integer) values.get(0));

        return info;
    }

    @SuppressWarnings("rawtypes")
    public static JobHistoryFilter property2jobHistoryFilter(Property property) {
        JobHistoryFilter filter = new JobHistoryFilter();
        ArrayList values = null;

        // 開始・再実行日時（自）取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.START_FROM_DATE);
        if (values.get(0) != null && values.get(0) instanceof Date) {
            filter.setStartFromDate((Date) values.get(0));
        }
        // 開始・再実行日時（至）取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.START_TO_DATE);
        if (values.get(0) != null && values.get(0) instanceof Date) {
            filter.setStartToDate((Date) values.get(0));
        }
        // 終了・中断日時（自）取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.END_FROM_DATE);
        if (values.get(0) != null && values.get(0) instanceof Date) {
            filter.setEndFromDate((Date) values.get(0));
        }
        // 終了・中断日時（至）取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.END_TO_DATE);
        if (values.get(0) != null && values.get(0) instanceof Date) {
            filter.setEndToDate((Date) values.get(0));
        }

        // ジョブID取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.JOB_ID);
        if (values.get(0) instanceof JobTreeItem) {
            filter.setJobId(((JobTreeItem) values.get(0)).getData().getId());
        } else if (values.get(0) instanceof String
                && ((String) values.get(0)).length() > 0) {
            filter.setJobId((String) values.get(0));
        }

        // 状態取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.STATUS);
        Integer status = null;
        if (values.get(0) instanceof String) {
            String statusString = (String) values.get(0);
            status = Integer.valueOf(StatusConstant.stringToType(statusString));
            filter.setStatus(status);
        }

        // 実行契機種別取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.TRIGGER_TYPE);
        Integer triggerType = null;
        if (values.get(0) instanceof String) {
            String triggerTypeString = (String) values.get(0);
            triggerType = Integer.valueOf(JobTriggerTypeConstant
                    .stringToType(triggerTypeString));
            filter.setTriggerType(triggerType);
        }

        // 実行契機情報取得
        values = PropertyUtil.getPropertyValue(property,
                HistoryFilterPropertyConstant.TRIGGER_INFO);
        String triggerInfo = null;
        if (!"".equals(values.get(0))) {
            triggerInfo = (String) values.get(0);
            filter.setTriggerInfo(triggerInfo);
        }
        return filter;
    }
}
