/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.util.PropertyUtil;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.EjbConnectionManager;

/**
 * ステータス情報取得するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetFilterStatus {

    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、ステータス一覧情報を取得します。
     * 
     * @param facilityId
     *            取得対象の親ファシリティID
     * @return ステータス情報一覧（Objectの2次元配列）
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getStatusList(String)
     */
    public ArrayList<ArrayList<Object>> getFilterInfo(String facilityId)
            throws HinemosWebException {

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        MonitorController monitor = ejbConnectionManager.getMonitorController();

        ArrayList<StatusInfoData> records = null;

        if (monitor == null) {
            return null;
        }

        try {
            records = monitor.getStatusList(facilityId);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.monitor.status.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.monitor.status.remote", e);
        } catch (CreateException e) {
            throw new HinemosWebException("exception.monitor.status.action", e);
        } catch (NamingException e) {
            throw new HinemosWebException("exception.monitor.status.action", e);
        } catch (FacilityNotFoundException e) {
            throw new HinemosWebException("exception.monitor.status.action", e);
        }

        if (records == null) {
            return null;
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
                .statusInfoDataListToArrayList(records);
        return list;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、条件にマッチしたステータス監視情報を返します。
     * 
     * @param facilityId
     *            取得対象の親ファシリティID
     * @param condition
     *            検索条件
     * @return ステータス情報一覧（Objectの2次元配列）
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getStatusList(String,
     *      Property)
     */
    public ArrayList<ArrayList<Object>> getFilterInfo(String facilityId,
            Property condition) throws HinemosWebException {

        PropertyUtil.deletePropertyDefine(condition);

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        MonitorController monitor = ejbConnectionManager.getMonitorController();

        ArrayList<StatusInfoData> records = null;

        if (monitor == null) {
            return null;
        }

        try {
            records = monitor.getStatusList(facilityId, condition);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.monitor.status.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.monitor.status.remote", e);
        } catch (CreateException e) {
            throw new HinemosWebException("exception.monitor.status.remote", e);
        } catch (NamingException e) {
            throw new HinemosWebException("exception.monitor.status.remote", e);
        } catch (FacilityNotFoundException e) {
            throw new HinemosWebException("exception.monitor.status.remote", e);
        }

        if (records == null) {
            return null;
        }

        ArrayList<ArrayList<Object>> list = ConvertListUtil
                .statusInfoDataListToArrayList(records);

        return list;
    }
}