/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.monitor.bean.StatusTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 監視[ステータス]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetStatusListTableDefine {

	/**
	 * 監視[ステータス]ビューのテーブル定義情報を取得します。<BR>
	 * <BR>
	 * リストに、カラム毎にテーブルカラム情報をセットします。
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
	 * 
	 * @see com.clustercontrol.bean.TableColumnInfoJs#TableColumnInfoJs(java.lang.String,
	 *      int, int, int)
	 * @see com.clustercontrol.monitor.bean.StatusTabelDefine
	 */

	public static ArrayList<TableColumnInfoJs> getStatusListTableDefine(
			Locale locale) {

		// Locale locale = Locale.getDefault();

		/** テーブル情報定義配列 */
		ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

		tableDefine.add(StatusTableDefine.PRIORITY, new TableColumnInfoJs(
				WebMessages.getString("priority", locale),
				TableColumnInfoJs.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(StatusTableDefine.PLUGIN_ID, new TableColumnInfoJs(
				WebMessages.getString("plugin.id", locale),
				TableColumnInfoJs.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTableDefine.MONITOR_ID, new TableColumnInfoJs(
				WebMessages.getString("monitor.id", locale),
				TableColumnInfoJs.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTableDefine.FACILITY_ID, new TableColumnInfoJs(
				WebMessages.getString("facility.id", locale),
				TableColumnInfoJs.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTableDefine.SCOPE,
				new TableColumnInfoJs(WebMessages.getString("scope", locale),
						TableColumnInfoJs.FACILITY, 150, SWT.LEFT));
		tableDefine.add(StatusTableDefine.APPLICATION, new TableColumnInfoJs(
				WebMessages.getString("application", locale),
				TableColumnInfoJs.NONE, 100, SWT.LEFT));
		tableDefine.add(StatusTableDefine.UPDATE_TIME, new TableColumnInfoJs(
				WebMessages.getString("update.time", locale),
				TableColumnInfoJs.NONE, 150, SWT.LEFT));
		tableDefine.add(StatusTableDefine.OUTPUT_TIME, new TableColumnInfoJs(
				WebMessages.getString("output.time", locale),
				TableColumnInfoJs.NONE, 150, SWT.LEFT));
		tableDefine.add(StatusTableDefine.MESSAGE_ID, new TableColumnInfoJs(
				WebMessages.getString("message.id", locale),
				TableColumnInfoJs.NONE, 200, SWT.LEFT));
		tableDefine.add(StatusTableDefine.MESSAGE, new TableColumnInfoJs(
				WebMessages.getString("message", locale), TableColumnInfoJs.NONE,
				200, SWT.LEFT));

		return tableDefine;
	}

}