/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.EventTableDefine;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.action.GetFilterEvent;
import com.necsoft.hinemos.webclient.monitor.form.MonitorEventForm;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetEventListBusiness {

    public ArrayList<ArrayList<Object>> getEventList(MonitorEventForm form,
            Property condition, NamingContext namingContext)
            throws HinemosWebException {

        ArrayList<ArrayList<Object>> listInfo = null;

        if (condition == null) {
            listInfo = getViewListInfo(form, namingContext);
        } else {
            listInfo = getViewListInfo(form, condition, namingContext);
        }

        doSortListLogData(form, listInfo);

        return listInfo;
    }

    public GridDataJson doConvertToJson(
            ArrayList<ArrayList<Object>> listInfoData, Locale locale)
            throws HinemosWebException {

        // Create JSON
        GridDataJson result = new GridDataJson();

        // Rows
        for (int countRow = 0; countRow < listInfoData.size();) {
            ArrayList<Object> logData = listInfoData.get(countRow);
            result.addRow(logData, String.valueOf(++countRow));
        }

        // Set other content
        result.setRecords(listInfoData.size());
        return result;
    }

    private ArrayList<ArrayList<Object>> getViewListInfo(MonitorEventForm form,
            NamingContext namingContext) throws HinemosWebException {
        ArrayList<ArrayList<Object>> listInfo = null;
        GetFilterEvent getFilterEvent = new GetFilterEvent();
        getFilterEvent.setNamingContext(namingContext);

        listInfo = getFilterEvent.getFilterInfo(
                StringEscapeUtils.unescapeHtml(form.getFacilityId()),
                MonitorConstants.NUMBER_EVENT_MAX);

        return listInfo;
    }

    private ArrayList<ArrayList<Object>> getViewListInfo(MonitorEventForm form,
            Property condition, NamingContext namingContext)
            throws HinemosWebException {
        ArrayList<ArrayList<Object>> listInfo = null;
        GetFilterEvent getFilterEvent = new GetFilterEvent();
        getFilterEvent.setNamingContext(namingContext);

        listInfo = getFilterEvent.getFilterInfo(
                StringEscapeUtils.unescapeHtml(form.getFacilityId()),
                condition, MonitorConstants.NUMBER_EVENT_MAX);

        return listInfo;
    }

    private void doSortListLogData(MonitorEventForm form,
            ArrayList<ArrayList<Object>> list) {

        // Get sorting parameter
        int sortColumnIndex = EventTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = EventTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !form.getSidx().trim().equals("")) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !form.getSord().trim().equals("")) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }
        // データをソート
        Collections.sort(list, new CommonTableViewerSorter(sortColumnIndex, -1,
                sortOrder));
    }
}
