/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.StatusTableDefine;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.monitor.action.GetFilterStatus;
import com.necsoft.hinemos.webclient.monitor.form.MonitorStatusForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetStatusListBusiness {

    public ArrayList<ArrayList<Object>> getStatusList(MonitorStatusForm form,
            Property condition, NamingContext namingContext)
            throws HinemosWebException {
        ArrayList<ArrayList<Object>> listStatusData = null;
        if (condition == null) {
            listStatusData = getListStatusData(form, namingContext);
        } else {
            listStatusData = getListStatusData(form, condition, namingContext);
        }

        doSortListDataInfo(form, listStatusData);

        ConvertListUtil.sanitizeStatusInfoData(listStatusData);

        return listStatusData;
    }

    public GridDataJson doConvertToJson(
            ArrayList<ArrayList<Object>> listInfoData, Locale locale) {
        // Create JSON
        GridDataJson result = new GridDataJson();

        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            ArrayList<Object> infoData = listInfoData.get(countRow);
            result.addRow(infoData, String.valueOf(countRow + 1));
        }

        // Set other content
        result.setRecords(listInfoData.size());
        return result;
    }

    private ArrayList<ArrayList<Object>> getListStatusData(
            MonitorStatusForm form, NamingContext namingContext)
            throws HinemosWebException {
        ArrayList<ArrayList<Object>> listStatusData;
        // ステータス情報一覧データ(StatusInfoData)を取得
        GetFilterStatus getFilterStatus = new GetFilterStatus();
        getFilterStatus.setNamingContext(namingContext);
        listStatusData = getFilterStatus.getFilterInfo(StringEscapeUtils
                .unescapeHtml(form.getFacilityId()));

        return listStatusData;
    }

    private ArrayList<ArrayList<Object>> getListStatusData(
            MonitorStatusForm form, Property condition,
            NamingContext namingContext) throws HinemosWebException {
        ArrayList<ArrayList<Object>> listStatusData;
        // ステータス情報一覧データ(StatusInfoData)を取得
        GetFilterStatus getFilterStatus = new GetFilterStatus();
        getFilterStatus.setNamingContext(namingContext);
        listStatusData = getFilterStatus
                .getFilterInfo(
                        StringEscapeUtils.unescapeHtml(form.getFacilityId()),
                        condition);

        return listStatusData;
    }

    private void doSortListDataInfo(MonitorStatusForm form,
            ArrayList<ArrayList<Object>> listInfoData) {
        // Get sorting parameter
        int sortColumnIndex = StatusTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = StatusTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !form.getSidx().trim().equals("")) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !form.getSord().trim().equals("")) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }
        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
    }

}
