/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.repository.bean.ScopeListTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 登録スコープ一覧のテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetScopeListTableDefine {

    // ----- instance メソッド ----- //

    /**
     * スコープ一覧テーブル定義を取得します。<BR>
     * 
     * @return ノード一覧
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        /** メイン処理 */
        tableDefine.add(
                ScopeListTableDefine.FACILITY_ID,
                new TableColumnInfoJs(WebMessages.getString("facility.id",
                        locale), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
        tableDefine.add(
                ScopeListTableDefine.FACILITY_NAME,
                new TableColumnInfoJs(WebMessages.getString("facility.name",
                        locale), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
        tableDefine.add(
                ScopeListTableDefine.DESCRIPTION,
                new TableColumnInfoJs(WebMessages.getString("description",
                        locale), TableColumnInfo.NONE, 200, SWT.LEFT));

        return tableDefine;

    }
}