/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.Locale;

import com.clustercontrol.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.repository.action.GetNodeFilterProperty;

/**
 * This class used to display NodeFilterProperty
 * 
 * @version 1.0
 * @date 2012/1/14
 */
public class GetNodeFilterPropertyBusiness {

    public Property getNodeFilterProperty(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        Property result = null;
        GetNodeFilterProperty nodeProperty = null;
        // Get node property
        nodeProperty = new GetNodeFilterProperty();
        result = nodeProperty.getProperty(locale);
        if (result == null) {
            throw new HinemosWebInvalidDataException(
                    "exception.repository.node.filter");
        }
        return result;
    }
}
