/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.util;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.lang.StringEscapeUtils;

import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.clustercontrol.repository.bean.NodeScopeTabelDefine;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.bean.ScopeListTableDefine;

/**
 * This class used for convert repository of info to array list.
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class ConvertListUtil {

    /**
     * This method used for convert repository of NodeInfo to array list.
     * 
     * @param listInfoData
     *            : ArrayList<NodeInfo>
     * @return ArrayList<ArrayList>
     */
    public static ArrayList<ArrayList> convertNodeInfoListToArrayList(
            ArrayList<NodeInfo> listInfoData) {

        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        Iterator<NodeInfo> itr = listInfoData.iterator();

        while (itr.hasNext()) {
            ArrayList scopeList = new ArrayList();
            NodeInfo nodeInfo = itr.next();

            scopeList.add(NodeListTabelDefine.FACILITY_ID,
                    StringEscapeUtils.escapeHtml(nodeInfo.getFacilityId()));
            scopeList.add(NodeListTabelDefine.FACILITY_NAME,
                    StringEscapeUtils.escapeHtml(nodeInfo.getFacilityName()));
            scopeList.add(NodeListTabelDefine.DESCRIPTION,
                    StringEscapeUtils.escapeHtml(nodeInfo.getDescription()));

            result.add(scopeList);
        }

        return result;
    }

    /**
     * This method used for convert repository of NodeScopeInfo to array list.
     * 
     * @param listInfoData
     *            : ArrayList<?>
     * @return ArrayList<String>
     */
    public static ArrayList<String> convertNodeScopeInfoToList(
            ArrayList<?> listInfoData) {

        ArrayList result = new ArrayList<String>();
        // Set rows
        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            ArrayList<String> infoData = new ArrayList<String>();
            infoData.add(NodeScopeTabelDefine.SCOPE, listInfoData.get(countRow)
                    + "");
            result.add(infoData);
        }
        return result;
    }

    /**
     * This method used for convert repository of ScopeInfo to array list.
     * 
     * @param listInfoData
     *            : ArrayList<ScopeInfo>
     * @return ArrayList<ArrayList>
     */
    public static ArrayList<ArrayList> convertScopeInfoListToArrayList(
            ArrayList<ScopeInfo> listInfoData) {

        ArrayList<ArrayList> result = new ArrayList<ArrayList>();
        Iterator<ScopeInfo> itr = listInfoData.iterator();

        while (itr.hasNext()) {
            ArrayList scopeList = new ArrayList();
            ScopeInfo scopeInfo = itr.next();
            scopeList.add(ScopeListTableDefine.FACILITY_ID,
                    scopeInfo.getFacilityId());
            scopeList.add(ScopeListTableDefine.FACILITY_NAME,
                    scopeInfo.getFacilityName());
            scopeList.add(ScopeListTableDefine.DESCRIPTION,
                    scopeInfo.getDescription());
            result.add(scopeList);
        }
        return result;
    }
}
